/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.tips;

import javax.inject.Inject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.tips.AbstractCompletionTipProposal;
import org.eclipse.recommenders.internal.completion.rcp.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.Dialogs;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class DiscoveryCompletionProposal
extends AbstractCompletionTipProposal {
    private static final String DISCOVERY_URL = "http://download.eclipse.org/recommenders/discovery/2.0/completion/directory.xml";

    @Inject
    public DiscoveryCompletionProposal(SharedImages images) {
        Image image = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LIGHTBULB);
        this.setImage(image);
        StyledString text = new StyledString(Messages.PROPOSAL_LABEL_DISCOVER_EXTENSIONS, StyledString.DECORATIONS_STYLER);
        this.setStyledDisplayString(text);
        this.setSortString(text.getString());
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        Dialogs.newExtensionsDiscoveryDialog((String)DISCOVERY_URL).open();
    }

    @Override
    protected IInformationControl createInformationControl(Shell parent, String statusLineText) {
        return new ConfigureContentAssistInformationControl(parent, statusLineText);
    }

    private static final class ConfigureContentAssistInformationControl
    extends AbstractInformationControl {
        private ConfigureContentAssistInformationControl(Shell parent, String statusLineText) {
            super(parent, statusLineText);
            this.create();
        }

        public boolean hasContents() {
            return true;
        }

        protected void createContent(Composite parent) {
            Link link = new Link(parent, 0);
            Dialog.applyDialogFont((Control)link);
            link.setForeground(parent.getForeground());
            link.setBackground(parent.getBackground());
            link.setText(Messages.PROPOSAL_TOOLTIP_DISCOVER_EXTENSIONS);
        }
    }
}

