/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jdt;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.recommenders.internal.jdt.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public class JavaElementsFinder {
    public static ImmutableList<IJavaProject> findAccessibleJavaProjects() {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            JavaModelManager mgr = JavaModelManager.getJavaModelManager();
            b.add((Object[])mgr.getJavaModel().getJavaProjects());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_JAVA_PROJECTS, (Throwable)e);
        }
        return b.build();
    }

    public static ImmutableList<IPackageFragmentRoot> findSourceRoots(IJavaProject project) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (1 == root.getKind()) {
                    b.add((Object)root);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT_ROOTS, (Throwable)e, (Object[])new Object[]{project});
        }
        return b.build();
    }

    public static ImmutableList<IPackageFragmentRoot> findPackageRootsWithSources(IJavaProject project) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (1 == root.getKind()) {
                    b.add((Object)root);
                } else if (2 == root.getKind() && JavaElementsFinder.hasSourceAttachment(root)) {
                    b.add((Object)root);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT_ROOTS, (Throwable)e, (Object[])new Object[]{project});
        }
        return b.build();
    }

    public static ImmutableList<IPackageFragment> findPackages(IPackageFragmentRoot root) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            IJavaElement[] iJavaElementArray = root.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                b.add((Object)((IPackageFragment)e));
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT, (Throwable)e, (Object[])new Object[]{root});
        }
        return b.build();
    }

    public static ImmutableList<ICompilationUnit> findCompilationUnits(IPackageFragment fragment) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            b.add((Object[])fragment.getCompilationUnits());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_COMPILATION_UNITS, (Throwable)e, (Object[])new Object[]{fragment});
        }
        return b.build();
    }

    public static ImmutableList<IClassFile> findClassFiles(IPackageFragment fragment) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            b.add((Object[])fragment.getClassFiles());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_CLASS_FILES, (Throwable)e, (Object[])new Object[]{fragment});
        }
        return b.build();
    }

    public static Optional<IType> findType(String typename, IJavaProject project) {
        try {
            return Optional.fromNullable((Object)project.findType(typename));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FIND_TYPE_IN_PROJECT, (Throwable)e, (Object[])new Object[]{typename, project});
            return Optional.absent();
        }
    }

    public static Optional<File> findLocation(ICompilationUnit cu) {
        if (cu == null) {
            return Optional.absent();
        }
        IResource resource = cu.getResource();
        if (resource == null) {
            return Optional.absent();
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return Optional.absent();
        }
        File file = location.toFile();
        if (!file.exists()) {
            return Optional.absent();
        }
        return Optional.of((Object)file);
    }

    public static boolean hasSourceAttachment(IPackageFragmentRoot fragmentRoot) {
        try {
            return fragmentRoot.getSourceAttachmentPath() != null;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_SOURCE_ATTACHMENT_PATH, (Throwable)e, (Object[])new Object[]{fragmentRoot});
            return false;
        }
    }
}

