/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.recommenders.internal.models.rcp.Dependencies;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.IDependencyListener;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.SearchContext;
import org.eclipse.recommenders.utils.Logs;

public class JavaEditorSearchContext
extends SearchContext {
    private final JavaContentAssistInvocationContext invocationContext;

    public JavaEditorSearchContext(String searchText, JavaContentAssistInvocationContext invocationContext, IDependencyListener dependencyListener, IProjectCoordinateProvider pcProvider) {
        super(searchText, JavaEditorSearchContext.getLocation(invocationContext), JavaEditorSearchContext.getAvailableDependencies(invocationContext, pcProvider, dependencyListener));
        this.invocationContext = invocationContext;
    }

    private static Set<ProjectCoordinate> getAvailableDependencies(JavaContentAssistInvocationContext invocationContext, IProjectCoordinateProvider pcProvider, IDependencyListener dependencyListener) {
        IJavaProject project = invocationContext.getCompilationUnit().getJavaProject();
        ImmutableSet availableDependencies = dependencyListener.getDependenciesForProject(Dependencies.createDependencyInfoForProject((IJavaProject)project));
        return JavaEditorSearchContext.resolve(pcProvider, (Set<DependencyInfo>)availableDependencies);
    }

    private static Set<ProjectCoordinate> resolve(IProjectCoordinateProvider pcProvider, Set<DependencyInfo> dependencyInfos) {
        HashSet result = Sets.newHashSet();
        for (DependencyInfo dependencyInfo : dependencyInfos) {
            ProjectCoordinate pc = (ProjectCoordinate)pcProvider.resolve(dependencyInfo).orNull();
            if (pc == null) continue;
            result.add(pc);
        }
        return result;
    }

    private static Location getLocation(JavaContentAssistInvocationContext context) {
        try {
            String partition = TextUtilities.getContentType((IDocument)context.getDocument(), (String)"___java_partitioning", (int)context.getInvocationOffset(), (boolean)true);
            if (partition.equals("__java_javadoc")) {
                return Location.JAVADOC;
            }
            CompletionContext coreContext = context.getCoreContext();
            if (coreContext != null) {
                int tokenLocation = coreContext.getTokenLocation();
                if ((tokenLocation & 1) != 0) {
                    return Location.JAVA_TYPE_MEMBERS;
                }
                if ((tokenLocation & 2) != 0) {
                    return Location.JAVA_STATEMENTS;
                }
                return Location.UNKNOWN;
            }
        }
        catch (BadLocationException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_COMPUTE_LOCATION, (Throwable)e);
        }
        return Location.FILE;
    }

    public JavaContentAssistInvocationContext getInvocationContext() {
        return this.invocationContext;
    }
}

