/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.collect.Lists;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.recommenders.internal.stacktraces.rcp.History;
import org.eclipse.recommenders.internal.stacktraces.rcp.Jobs;
import org.eclipse.recommenders.internal.stacktraces.rcp.Messages;
import org.eclipse.recommenders.internal.stacktraces.rcp.Shells;
import org.eclipse.recommenders.internal.stacktraces.rcp.UploadJob;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReports;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.RememberSendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class ErrorReportDialog
extends MessageDialog {
    private static final Image ERROR_ICON = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private Settings settings;
    private TableViewer tableViewer;
    private StyledText messageText;
    private IObservableList errors;
    private ErrorReport activeSelection;
    private Text commentText;
    private Button rememberDecisionButton;
    private ComboViewer rememberSettingCombo;
    private History history;
    private Button logMessageButton;
    private Button ignoreSimilarButton;

    public ErrorReportDialog(Shell parentShell, History history, Settings settings, IObservableList errors) {
        super(parentShell, "An Error Was Logged", null, "We noticed a new error event was logged. Such error events may reveal issues in the Eclipse codebase, and thus we kindly ask you to report them to eclipse.org.", 4, new String[]{"Send", "Don't Send"}, 0);
        this.history = history;
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
        this.settings = settings;
        this.errors = errors;
    }

    public int open() {
        int returnCode = super.open();
        this.reactivateModalShell();
        return returnCode;
    }

    private void reactivateModalShell() {
        Shell modalShellExcluding = (Shell)Shells.getModalShellExcluding(this.getShell()).orNull();
        if (modalShellExcluding != null) {
            modalShellExcluding.forceActive();
        }
    }

    protected boolean customShouldTakeFocus() {
        return false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setLayout((Layout)new GridLayout(1, false));
    }

    public Composite createCustomArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.createCommentContainer(parent, container);
        this.createDetailsContainer(parent, container);
        Composite settingsComposite = this.createSettingsComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).indent(0, 5).align(1, 0x1000000).applyTo((Control)settingsComposite);
        return container;
    }

    protected void createCommentContainer(final Composite parent, Composite container) {
        ExpandableComposite commentContainer = new ExpandableComposite(container, 0);
        commentContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        commentContainer.setText("Comments");
        commentContainer.setExpanded(true);
        Composite commentContent = new Composite((Composite)commentContainer, 0);
        GridLayoutFactory.fillDefaults().applyTo(commentContent);
        this.commentText = new Text(commentContent, 2114);
        this.commentText.setToolTipText("If possible, please provide additional information such as steps that allow committers to reproduce this error.");
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String comment = ErrorReportDialog.this.commentText.getText();
                for (Object errorReport : ErrorReportDialog.this.errors) {
                    ((ErrorReport)errorReport).setComment(comment);
                }
                ErrorReportDialog.this.updateMessageText();
            }
        });
        GridDataFactory.fillDefaults().hint(-1, 50).grab(true, false).applyTo((Control)this.commentText);
        commentContainer.setClient((Control)commentContent);
        commentContainer.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.getShell().pack();
            }
        });
    }

    protected void createDetailsContainer(final Composite parent, Composite container) {
        ExpandableComposite detailsContainer = new ExpandableComposite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)detailsContainer);
        detailsContainer.setText("Details");
        Composite detailsContent = this.createDetailsContent((Composite)detailsContainer);
        detailsContainer.setClient((Control)detailsContent);
        detailsContainer.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.getShell().pack();
            }
        });
    }

    private Composite createDetailsContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        SashForm sash = new SashForm(container, 256);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sash);
        this.createTableComposite((Composite)sash);
        this.createMessageComposite((Composite)sash);
        sash.setWeights(new int[]{20, 80});
        return container;
    }

    private Composite createTableComposite(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        this.tableViewer = new TableViewer(tableComposite, 68354);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ErrorReport event = (ErrorReport)element;
                return event.getStatus().getMessage();
            }

            public Image getImage(Object element) {
                return ERROR_ICON;
            }
        });
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.tableViewer.setInput((Object)this.errors);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ErrorReportDialog.this.updateMessageText();
            }
        });
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    this.deleteSelection();
                }
            }

            private void deleteSelection() {
                IStructuredSelection selection = (IStructuredSelection)ErrorReportDialog.this.tableViewer.getSelection();
                ErrorReportDialog.this.errors.removeAll((Collection)selection.toList());
            }
        });
        return tableComposite;
    }

    private void updateMessageText() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.activeSelection = (ErrorReport)selection.getFirstElement();
            ErrorReport copy = ErrorReports.copy(this.activeSelection);
            copy.setName(this.settings.getName());
            copy.setEmail(this.settings.getEmail());
            this.messageText.setText(ErrorReports.prettyPrint(copy, this.settings));
            this.logMessageButton.setSelection(this.activeSelection.isLogMessage());
            this.ignoreSimilarButton.setSelection(this.activeSelection.isIgnoreSimilar());
        }
    }

    private Composite createMessageComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        Composite messageComposite = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().applyTo(messageComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)messageComposite);
        this.messageText = new StyledText(messageComposite, 2816);
        this.messageText.setEditable(false);
        this.messageText.setMargins(5, this.messageText.getTopMargin(), this.messageText.getRightMargin(), this.messageText.getBottomMargin());
        this.messageText.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.messageText.setForeground(new Color((Device)container.getDisplay(), 80, 80, 80));
        GridDataFactory.fillDefaults().minSize(100, 1).hint(100, 300).grab(true, true).applyTo((Control)this.messageText);
        this.logMessageButton = this.createAndConfigureCheckbox(container, Messages.FIELD_LABEL_NOT_AN_ERROR, Messages.TOOLTIP_NOT_AN_ERROR);
        this.logMessageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorReportDialog.this.activeSelection.setLogMessage(ErrorReportDialog.this.logMessageButton.getSelection());
                ErrorReportDialog.this.updateMessageText();
            }
        });
        this.ignoreSimilarButton = this.createAndConfigureCheckbox(container, Messages.FIELD_LABEL_IGNORE_SIMILAR_ERRORS_IN_FUTURE, Messages.TOOLTIP_IGNORE_SIMILAR_ERRORS_IN_FUTURE);
        this.ignoreSimilarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorReportDialog.this.activeSelection.setIgnoreSimilar(ErrorReportDialog.this.ignoreSimilarButton.getSelection());
                ErrorReportDialog.this.updateMessageText();
            }
        });
        return container;
    }

    private Button createAndConfigureCheckbox(Composite parent, String text, String toolTip) {
        Button checkbox = new Button(parent, 32);
        checkbox.setText(text);
        checkbox.setToolTipText(toolTip);
        return checkbox;
    }

    protected Composite createSettingsComposite(Composite parent) {
        Composite settingsComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(settingsComposite);
        this.rememberDecisionButton = new Button(settingsComposite, 32);
        this.rememberDecisionButton.setText("Remember my decision");
        this.rememberSettingCombo = new ComboViewer(settingsComposite);
        this.rememberSettingCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.rememberSettingCombo.getCombo().setEnabled(false);
        this.rememberSettingCombo.setInput((Object)new RememberSendAction[]{RememberSendAction.PERMANENT, RememberSendAction.RESTART, RememberSendAction.HOURS_24});
        this.rememberSettingCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                RememberSendAction mode = (RememberSendAction)element;
                switch (mode) {
                    case PERMANENT: {
                        return "permanently";
                    }
                    case RESTART: {
                        return "until restart";
                    }
                    case HOURS_24: {
                        return "for 24 hours";
                    }
                }
                return super.getText(element);
            }
        });
        this.rememberSettingCombo.setSelection((ISelection)new StructuredSelection((Object)RememberSendAction.PERMANENT));
        this.rememberDecisionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ErrorReportDialog.this.rememberSettingCombo.getCombo().setEnabled(ErrorReportDialog.this.rememberDecisionButton.getSelection());
            }
        });
        return settingsComposite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (buttonId == 1) {
            this.cancelPressed();
        }
    }

    protected void okPressed() {
        this.rememberSendAction(SendAction.SILENT);
        this.send((List<ErrorReport>)this.errors);
        super.okPressed();
    }

    private void send(List<ErrorReport> reports) {
        URI target = URI.create(this.settings.getServerUrl());
        LinkedList jobs = Lists.newLinkedList();
        for (ErrorReport report : reports) {
            UploadJob job = new UploadJob(report, this.history, this.settings, target);
            jobs.add(job);
        }
        Jobs.sequential(MessageFormat.format(Messages.UPLOADJOB_NAME, target), jobs);
    }

    protected void cancelPressed() {
        this.rememberSendAction(SendAction.IGNORE);
        this.history.remember((Iterable<ErrorReport>)this.errors);
        super.cancelPressed();
    }

    public boolean close() {
        this.errors.clear();
        return super.close();
    }

    private void rememberSendAction(SendAction action) {
        RememberSendAction rememberSendAction = this.selectRememberAction();
        this.settings.setRememberSendAction(rememberSendAction);
        if (rememberSendAction != RememberSendAction.NONE) {
            this.settings.setAction(action);
            if (rememberSendAction == RememberSendAction.HOURS_24) {
                this.settings.setRememberSendActionPeriodStart(System.currentTimeMillis());
            }
        }
    }

    private RememberSendAction selectRememberAction() {
        ISelection selection;
        if (this.rememberDecisionButton.getSelection() && !(selection = this.rememberSettingCombo.getSelection()).isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return (RememberSendAction)structuredSelection.getFirstElement();
        }
        return RememberSendAction.NONE;
    }

    public void create() {
        super.create();
        if (!this.errors.isEmpty()) {
            StructuredSelection selection = new StructuredSelection(this.tableViewer.getElementAt(0));
            this.tableViewer.setSelection((ISelection)selection, true);
        }
    }
}

