/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.recommenders.internal.stacktraces.rcp.LogMessages;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Bundle;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.StackTraceElement;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Status;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Throwable;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Visitor;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.impl.VisitorImpl;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.util.ModelSwitch;
import org.eclipse.recommenders.utils.Logs;
import org.osgi.framework.FrameworkUtil;

public class History
extends AbstractIdleService {
    private static final String F_VERSION = "version";
    private static final String F_IDENTITY = "identity";
    private static final String F_IDENTITY_TRACE = "identity-trace";
    private Directory index;
    private IndexWriter writer;
    private IndexReader reader;
    private IndexSearcher searcher;
    private Settings settings;

    public History(Settings settings) {
        this.settings = settings;
    }

    @VisibleForTesting
    protected Directory createIndexDirectory() throws IOException {
        org.osgi.framework.Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        IPath stateLocation = Platform.getStateLocation((org.osgi.framework.Bundle)bundle);
        File indexdir = new File(stateLocation.toFile(), "history");
        indexdir.mkdirs();
        return FSDirectory.open((File)indexdir);
    }

    protected void startUp() throws Exception {
        this.index = this.createIndexDirectory();
        this.createWriter();
        this.createReaderAndSearcher();
    }

    private void createWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.writer = new IndexWriter(this.index, conf);
        if (this.writer.numDocs() == 0) {
            this.buildInitialIndex();
        }
    }

    private void buildInitialIndex() throws CorruptIndexException, IOException {
        Document meta = new Document();
        meta.add((Fieldable)new Field(F_VERSION, "0.6", Field.Store.YES, Field.Index.NO));
        this.writer.addDocument(meta);
        this.writer.commit();
    }

    private void createReaderAndSearcher() throws CorruptIndexException, IOException {
        this.reader = IndexReader.open((Directory)this.index);
        this.searcher = new IndexSearcher(this.reader);
    }

    public boolean seen(ErrorReport report) {
        return this.seen((Query)new TermQuery(new Term(F_IDENTITY, this.exactIdentity(report))));
    }

    public boolean seenSimilar(ErrorReport report) {
        return this.seen((Query)new TermQuery(new Term(F_IDENTITY_TRACE, this.traceIdentity(report))));
    }

    private boolean seen(Query q) {
        try {
            this.renewReaderAndSearcher();
            TopDocs results = this.searcher.search(q, 1);
            boolean foundIdenticalReport = results.totalHits > 0;
            return foundIdenticalReport;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.HISTORY_NOT_AVAILABLE, (java.lang.Throwable)e);
            return false;
        }
    }

    private String exactIdentity(ErrorReport report) {
        final Hasher hasher = Hashing.murmur3_128().newHasher();
        ModelSwitch<Hasher> s = new ModelSwitch<Hasher>(){

            public Hasher caseErrorReport(ErrorReport object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseProduct()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getEclipseBuildId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getJavaRuntimeVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOs()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiOsVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiArch()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getOsgiWs()), Charsets.UTF_8);
                return hasher;
            }

            public Hasher caseStatus(Status object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginId()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getPluginVersion()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                hasher.putInt(object.getSeverity());
                hasher.putInt(object.getCode());
                return hasher;
            }

            public Hasher caseBundle(Bundle object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getVersion()), Charsets.UTF_8);
                return hasher;
            }

            public Hasher caseStackTraceElement(StackTraceElement object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMethodName()), Charsets.UTF_8);
                hasher.putInt(object.getLineNumber());
                return hasher;
            }

            public Hasher caseThrowable(Throwable object) {
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getClassName()), Charsets.UTF_8);
                hasher.putString((CharSequence)StringUtils.stripToEmpty((String)object.getMessage()), Charsets.UTF_8);
                return hasher;
            }
        };
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)report, (boolean)true);
        while (iterator.hasNext()) {
            EObject modelElement = (EObject)iterator.next();
            s.doSwitch(modelElement);
        }
        return hasher.hash().toString();
    }

    private String traceIdentity(ErrorReport report) {
        final Hasher hasher = Hashing.murmur3_128().newHasher();
        report.accept((Visitor)new VisitorImpl(){

            public void visit(StackTraceElement element) {
                hasher.putString((CharSequence)element.getClassName(), Charsets.UTF_8);
                hasher.putString((CharSequence)element.getMethodName(), Charsets.UTF_8);
                hasher.putInt(element.getLineNumber());
            }
        });
        String hash = hasher.hash().toString();
        return hash;
    }

    private void renewReaderAndSearcher() throws IOException {
        IndexReader tmp = IndexReader.openIfChanged((IndexReader)this.reader);
        if (tmp != null) {
            IOUtils.close((Closeable[])new Closeable[]{this.reader, this.searcher});
            this.searcher = new IndexSearcher(tmp);
            this.reader = tmp;
        }
    }

    public void remember(Iterable<ErrorReport> reports) {
        for (ErrorReport report : reports) {
            this.remember(report);
        }
    }

    public void remember(ErrorReport report) {
        if (this.seen(report)) {
            return;
        }
        Document doc = new Document();
        Field field = new Field(F_IDENTITY, this.exactIdentity(report), Field.Store.NO, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        if (report.isIgnoreSimilar()) {
            field = new Field(F_IDENTITY_TRACE, this.traceIdentity(report), Field.Store.NO, Field.Index.NOT_ANALYZED);
            doc.add((Fieldable)field);
        }
        try {
            this.writer.addDocument(doc);
            this.writer.commit();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.HISTORY_NOT_AVAILABLE, (java.lang.Throwable)e);
        }
    }

    protected void shutDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.searcher, this.reader, this.writer, this.index});
    }
}

