/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.recommenders.internal.stacktraces.rcp.Configurator;
import org.eclipse.recommenders.internal.stacktraces.rcp.ErrorReportDialog;
import org.eclipse.recommenders.internal.stacktraces.rcp.History;
import org.eclipse.recommenders.internal.stacktraces.rcp.LogMessages;
import org.eclipse.recommenders.internal.stacktraces.rcp.PreferenceInitializer;
import org.eclipse.recommenders.internal.stacktraces.rcp.Shells;
import org.eclipse.recommenders.internal.stacktraces.rcp.StandInStacktraceProvider;
import org.eclipse.recommenders.internal.stacktraces.rcp.UploadJob;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReports;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Status;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class LogListener
implements ILogListener,
IStartup {
    private IObservableList queueUI;
    private ArrayList<ErrorReport> queueRO;
    private StandInStacktraceProvider stacktraceProvider = new StandInStacktraceProvider();
    private History history;
    private Settings settings;
    private final Semaphore sendDialogLock = new Semaphore(1);
    private final Semaphore configureDialogLock = new Semaphore(1);

    public LogListener() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LogListener.this.queueRO = Lists.newArrayList();
                LogListener.this.queueUI = Properties.selfList(ErrorReport.class).observe((Object)LogListener.this.queueRO);
            }
        });
    }

    @VisibleForTesting
    public LogListener(History history, Settings settings) {
        this();
        this.history = history;
        this.settings = settings;
    }

    public void earlyStartup() {
        this.settings = PreferenceInitializer.getDefault();
        Platform.addLogListener((ILogListener)this);
        try {
            this.history = new History(this.settings);
            this.history.startAsync();
        }
        catch (Exception exception) {
            Logs.log((Logs.ILogMessage)LogMessages.HISTORY_START_FAILED);
        }
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                try {
                    LogListener.this.history.stopAsync();
                    LogListener.this.history.awaitTerminated();
                }
                catch (Exception exception) {
                    Logs.log((Logs.ILogMessage)LogMessages.HISTORY_STOP_FAILED);
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
    }

    public void logging(IStatus status, String nouse) {
        try {
            if (!this.isReportingAllowedInEnvironment() || !this.isErrorSeverity(status) || this.isWorkbenchClosing() || !this.isHistoryRunning() || this.isQueueLimitReached()) {
                return;
            }
            if (!this.configureDialogLock.tryAcquire()) {
                return;
            }
            try {
                if (!this.settings.isConfigured()) {
                    this.firstConfiguration();
                }
            }
            finally {
                this.configureDialogLock.release();
            }
            if (!this.settings.isConfigured()) {
                Logs.log((Logs.ILogMessage)LogMessages.FIRST_CONFIGURATION_FAILED);
                return;
            }
            if (!LogListener.hasPluginIdWhitelistedPrefix(status, this.settings.getWhitelistedPluginIds())) {
                return;
            }
            SendAction sendAction = this.settings.getAction();
            if (!this.isSendingAllowedOnAction(sendAction)) {
                return;
            }
            ErrorReport report = ErrorReports.newErrorReport(status, this.settings);
            if (this.filterEmptyUiMonitoring(report)) {
                return;
            }
            this.stacktraceProvider.insertStandInStacktraceIfEmpty(report.getStatus(), this.settings);
            ErrorReports.guessInvolvedPlugins(report);
            if (this.alreadyQueued(report) || this.seenSameOrSimilarErrorBefore(report)) {
                return;
            }
            this.addForSending(report);
            if (sendAction == SendAction.ASK) {
                this.checkAndSendWithDialog(report);
            } else if (sendAction == SendAction.SILENT) {
                this.sendAndClear();
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.REPORTING_ERROR, (Throwable)e);
        }
    }

    private boolean isQueueLimitReached() {
        return this.queueRO.size() >= 20;
    }

    private boolean filterEmptyUiMonitoring(ErrorReport report) {
        Status status = report.getStatus();
        if ("org.eclipse.ui.monitoring".equals(status.getPluginId())) {
            return status.getChildren().isEmpty();
        }
        return false;
    }

    private boolean alreadyQueued(ErrorReport report) {
        for (ErrorReport r : this.queueRO) {
            if (!EcoreUtil.equals((EObject)report, (EObject)r)) continue;
            return true;
        }
        return false;
    }

    private boolean isHistoryRunning() {
        if (this.history == null) {
            return false;
        }
        return this.history.isRunning();
    }

    private boolean isWorkbenchClosing() {
        return PlatformUI.getWorkbench().isClosing();
    }

    private boolean isReportingAllowedInEnvironment() {
        return !this.skipSendingReports() && !this.isRuntimeEclipse();
    }

    private void sendAndClear() {
        this.sendList();
        this.clear();
    }

    private void sendList() {
        for (ErrorReport entry : this.queueRO) {
            ErrorReport report = (ErrorReport)Checks.cast((Object)entry);
            this.sendStatus(report);
        }
    }

    private void clear() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LogListener.this.queueUI.clear();
            }
        });
    }

    private boolean skipSendingReports() {
        return Boolean.getBoolean("org.eclipse.recommenders.stacktraces.rcp.skipReports");
    }

    private boolean isRuntimeEclipse() {
        return System.getProperty("eclipse.buildId") == null;
    }

    private boolean isErrorSeverity(IStatus status) {
        return status.matches(4);
    }

    private static boolean hasPluginIdWhitelistedPrefix(IStatus status, List<String> whitelistedIdPrefixes) {
        String pluginId = status.getPlugin();
        for (String id : whitelistedIdPrefixes) {
            if (!pluginId.startsWith(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isSendingAllowedOnAction(SendAction sendAction) {
        return sendAction == SendAction.ASK || sendAction == SendAction.SILENT;
    }

    private boolean seenSameOrSimilarErrorBefore(ErrorReport report) {
        if (!this.settings.isSkipSimilarErrors()) {
            return false;
        }
        return this.history.seenSimilar(report) || this.history.seen(report);
    }

    private void firstConfiguration() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Optional<Shell> shell = LogListener.this.getWorkbenchWindowShell();
                    if (shell.isPresent()) {
                        Configurator.ConfigureWithDialog(LogListener.this.settings, (Shell)shell.get());
                    }
                }
                catch (Exception e) {
                    Logs.log((Logs.ILogMessage)LogMessages.REPORTING_ERROR, (Throwable)e);
                }
            }
        });
    }

    private void addForSending(final ErrorReport report) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LogListener.this.queueUI.add((Object)report);
            }
        };
        Display current = Display.getCurrent();
        if (current != null) {
            run.run();
        } else {
            Display.getDefault().asyncExec(run);
        }
    }

    @VisibleForTesting
    protected void checkAndSendWithDialog(ErrorReport report) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!LogListener.this.sendDialogLock.tryAcquire()) {
                    return;
                }
                try {
                    Optional<Shell> shell = LogListener.this.getWorkbenchWindowShell();
                    if (shell.isPresent()) {
                        ErrorReportDialog reportDialog = new ErrorReportDialog((Shell)shell.get(), LogListener.this.history, LogListener.this.settings, LogListener.this.queueUI){

                            @Override
                            public boolean close() {
                                boolean close = super.close();
                                if (close) {
                                    LogListener.this.sendDialogLock.release();
                                }
                                return close;
                            }
                        };
                        reportDialog.open();
                    }
                }
                catch (Exception exception) {
                    LogListener.this.sendDialogLock.release();
                }
            }
        });
    }

    @VisibleForTesting
    protected void sendStatus(ErrorReport report) {
        if (this.settings.getAction() == SendAction.IGNORE) {
            return;
        }
        new UploadJob(report, this.history, this.settings, URI.create(this.settings.getServerUrl())).schedule();
    }

    @VisibleForTesting
    protected Optional<Shell> getWorkbenchWindowShell() {
        return Shells.getWorkbenchWindowShell();
    }
}

