/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.recommenders.internal.stacktraces.rcp.Constants;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReports;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Status;

public class StandInStacktraceProvider {
    private static final String STAND_IN_MESSAGE = "Stand-In Stacktrace supplied by Eclipse Stacktraces & Error Reporting Tool";

    protected void insertStandInStacktraceIfEmpty(Status status, Settings settings) {
        if (this.requiresStandInStacktrace(status)) {
            StandInException syntetic = new StandInException(STAND_IN_MESSAGE);
            syntetic.fillInStackTrace();
            StackTraceElement[] stacktrace = syntetic.getStackTrace();
            StackTraceElement[] clearedStacktrace = this.clearBlacklistedTopStackframes(stacktrace, Constants.STAND_IN_STACKTRACE_BLACKLIST);
            syntetic.setStackTrace(clearedStacktrace);
            status.setException(ErrorReports.newThrowable(syntetic));
            status.setFingerprint(ErrorReports.computeFingerprintFor(status, settings));
        }
    }

    private boolean requiresStandInStacktrace(Status status) {
        return status.getException() == null;
    }

    protected StackTraceElement[] clearBlacklistedTopStackframes(StackTraceElement[] stackframes, Set<String> blacklistedClassNames) {
        if (ArrayUtils.isEmpty((Object[])stackframes)) {
            return stackframes;
        }
        int index = this.findCutOffIndex(stackframes, blacklistedClassNames);
        return (StackTraceElement[])ArrayUtils.subarray((Object[])stackframes, (int)index, (int)stackframes.length);
    }

    private int findCutOffIndex(StackTraceElement[] stackframes, Set<String> blacklistedClassNames) {
        int i = 0;
        while (i < stackframes.length) {
            StackTraceElement current = stackframes[i];
            if (!blacklistedClassNames.contains(current.getClassName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static class StandInException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StandInException(String message) {
            super(message);
        }
    }
}

