/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.inference;

import java.util.Map;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.AbstractInferer;
import org.eclipse.recommenders.jayes.sampling.BasicSampler;
import org.eclipse.recommenders.jayes.util.BayesNodeUtil;
import org.eclipse.recommenders.jayes.util.MathUtils;

public class LikelihoodWeightedSampling
extends AbstractInferer {
    private static final int DEFAULT_SAMPLE_COUNT = 200;
    private int sampleCount = 200;
    private final BasicSampler sampler = new BasicSampler();

    @Override
    public void setNetwork(BayesNet bn) {
        super.setNetwork(bn);
        this.sampler.setNetwork(bn);
    }

    @Override
    protected void updateBeliefs() {
        this.sampler.setEvidence(this.evidence);
        int i = 0;
        while (i < this.sampleCount) {
            Map<BayesNode, String> sample = this.sampler.sample();
            double weight = this.computeEvidenceProbability(sample);
            for (Map.Entry<BayesNode, String> e : sample.entrySet()) {
                BayesNode n = e.getKey();
                double[] dArray = this.beliefs[n.getId()];
                int n2 = n.getOutcomeIndex(e.getValue());
                dArray[n2] = dArray[n2] + weight;
            }
            ++i;
        }
        this.normalizeBeliefs();
    }

    private void normalizeBeliefs() {
        int i = 0;
        while (i < this.beliefs.length) {
            this.beliefs[i] = MathUtils.normalize(this.beliefs[i]);
            ++i;
        }
    }

    private double computeEvidenceProbability(Map<BayesNode, String> sample) {
        double factor = 1.0;
        for (BayesNode n : this.evidence.keySet()) {
            factor *= BayesNodeUtil.getSubCpt(n, sample)[n.getOutcomeIndex((String)this.evidence.get(n))];
        }
        return factor;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public void seed(long seed) {
        this.sampler.seed(seed);
    }
}

