/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.snipmatch.rcp.model.EclipseGitSnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnipmatchRcpModelFactory;
import org.eclipse.recommenders.utils.Logs;

public class DefaultGitSnippetRepositoryConfigurations {
    public static List<EclipseGitSnippetRepositoryConfiguration> fetchDefaultConfigurations() {
        IConfigurationElement[] elements;
        ArrayList defaultConfigurations = Lists.newArrayList();
        HashSet addedUrls = Sets.newHashSet();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.recommenders.snipmatch.rcp.defaultGitSnippetRepositoryConfigurations");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                String description = element.getAttribute("description");
                String url = element.getAttribute("url");
                if (addedUrls.contains(url)) {
                    Logs.log((Logs.ILogMessage)LogMessages.WARNING_DEFAULT_GIT_REPO_URL_DUPLICATE, (Object[])new Object[]{name, url});
                } else {
                    String pushUrl = element.getAttribute("pushUrl");
                    String pushBranchPrefix = element.getAttribute("pushBranchPrefix");
                    String priority = element.getAttribute("defaultPriority");
                    int priorityInteger = priority == null ? 0 : Integer.parseInt(priority);
                    defaultConfigurations.add(DefaultGitSnippetRepositoryConfigurations.createConfiguration(id, name, description, url, pushUrl, pushBranchPrefix, priorityInteger));
                    addedUrls.add(url);
                }
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_LOADING_DEFAULT_GIT_REPO_CONFIGURATION, (Throwable)e);
            }
            ++n2;
        }
        return defaultConfigurations;
    }

    private static EclipseGitSnippetRepositoryConfiguration createConfiguration(String id, String name, String description, String url, String pushUrl, String pushBranchPrefix, int priority) {
        EclipseGitSnippetRepositoryConfiguration configuration = SnipmatchRcpModelFactory.eINSTANCE.createEclipseGitSnippetRepositoryConfiguration();
        configuration.setId(id);
        configuration.setName(name);
        configuration.setDescription(description);
        configuration.setUrl(url);
        configuration.setPushUrl(pushUrl);
        configuration.setPushBranchPrefix(pushBranchPrefix);
        configuration.setPriority(priority);
        return configuration;
    }
}

