/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.recommenders.internal.types.rcp.ProjectTypesIndex;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TypesIndexService
implements IElementChangedListener,
IStartup {
    private static TypesIndexService INSTANCE;
    private Map<IJavaProject, ProjectTypesIndex> _indexes = Maps.newHashMap();

    public TypesIndexService() {
        INSTANCE = this;
    }

    public static TypesIndexService getInstance() {
        return INSTANCE;
    }

    public void earlyStartup() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)new ShutdownListener());
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        this.process(delta);
    }

    private void process(IJavaElementDelta delta) {
        boolean resolvedClasspathChanged;
        IJavaElement element = delta.getElement();
        IJavaProject project = element.getJavaProject();
        boolean bl = resolvedClasspathChanged = (delta.getFlags() & 0x200000) != 0;
        if (element instanceof IJavaProject && resolvedClasspathChanged) {
            this.rebuildIndex(element.getJavaProject());
            return;
        }
        if (this.isChildAffectedByChange(delta)) {
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                this.process(child);
                ++n2;
            }
            return;
        }
        block0 : switch (delta.getKind()) {
            case 1: {
                switch (element.getElementType()) {
                    case 5: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 3: {
                        this.rebuildIndex(project);
                        break;
                    }
                    case 2: {
                        this.rebuildIndex(project);
                    }
                }
                break;
            }
            case 4: {
                switch (element.getElementType()) {
                    case 5: {
                        break block0;
                    }
                    case 3: {
                        boolean content;
                        boolean reordered = (delta.getFlags() & 0x100) != 0;
                        boolean removed = (delta.getFlags() & 0x80) != 0;
                        boolean bl2 = content = (delta.getFlags() & 0x8000) != 0;
                        if (reordered) {
                            return;
                        }
                        if (!removed && !content) break block0;
                        this.rebuildIndex(project);
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (element.getElementType()) {
                    case 5: {
                        break block0;
                    }
                    case 3: {
                        this.rebuildIndex(project);
                        break block0;
                    }
                }
            }
        }
    }

    private void rebuildIndex(IJavaProject project) {
        ProjectTypesIndex index = this._indexes.get(project);
        if (index == null) {
            return;
        }
        if (index.needsRebuild()) {
            index.setRebuildAfterNextAccess(true);
        }
    }

    private synchronized ProjectTypesIndex findOrCreateIndex(IJavaProject project) {
        ProjectTypesIndex index = this._indexes.get(project);
        if (index == null) {
            index = new ProjectTypesIndex(project, this.computeIndexDir(project));
            this._indexes.put(project, index);
            index.startAsync();
        }
        return index;
    }

    private boolean isChildAffectedByChange(IJavaElementDelta delta) {
        return (delta.getFlags() & 8) != 0;
    }

    private File computeIndexDir(IJavaProject project) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        File location = Platform.getStateLocation((Bundle)bundle).toFile();
        File indexDir = new File(location, "indexes/" + project.getElementName().replaceAll("\\W", "_"));
        return indexDir;
    }

    public void close(IJavaProject project) {
    }

    public ImmutableSet<String> subtypes(IType expected, String prefix) {
        return this.findOrCreateIndex(expected.getJavaProject()).subtypes(expected, prefix);
    }

    public ImmutableSet<String> subtypes(ITypeName expected, String prefix, IJavaProject project) {
        return this.findOrCreateIndex(project).subtypes(expected, prefix);
    }

    public ImmutableSet<String> subtypes(String type, String prefix, IJavaProject project) {
        return this.findOrCreateIndex(project).subtypes(type, prefix);
    }

    public static class MutexRule
    implements ISchedulingRule {
        public static final MutexRule INSTANCE = new MutexRule();

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }

    private final class ShutdownListener
    implements IWorkbenchListener {
        private ShutdownListener() {
        }

        public boolean preShutdown(IWorkbench workbench, boolean forced) {
            return true;
        }

        public void postShutdown(IWorkbench workbench) {
            for (ProjectTypesIndex index : TypesIndexService.this._indexes.values()) {
                index.stopAsync();
            }
        }
    }
}

