/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.apidocs.rcp.Messages;
import org.eclipse.recommenders.internal.rcp.JavaElementSelections;
import org.eclipse.recommenders.internal.rcp.RcpPlugin;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.BrowserUtils;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public final class JavadocProvider
extends ApidocProvider {
    private static final String FG_STYLE_SHEET = JavadocProvider.loadStyleSheet();
    private final EventBus workspaceBus;
    private final JavaElementResolver resolver;

    @Inject
    public JavadocProvider(EventBus workspaceBus, JavaElementResolver resolver) {
        this.workspaceBus = workspaceBus;
        this.resolver = resolver;
    }

    @JavaSelectionSubscriber
    public void onCompilationUnitSelection(ITypeRoot root, JavaElementSelectionEvent selection, Composite parent) throws CoreException {
        IType type = root.findPrimaryType();
        if (type != null) {
            this.render((IMember)type, parent);
        } else if (root.getParent() instanceof IPackageFragment) {
            IPackageFragment packageFragment = (IPackageFragment)root.getParent();
            this.render(packageFragment, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onTypeSelection(IType type, JavaElementSelectionEvent selection, Composite parent) throws JavaModelException {
        this.render((IMember)type, parent);
    }

    @JavaSelectionSubscriber
    public void onMethodSelection(IMethod method, JavaElementSelectionEvent selection, Composite parent) throws JavaModelException {
        this.render((IMember)method, parent);
    }

    @JavaSelectionSubscriber
    public void onFieldSelection(IField field, JavaElementSelectionEvent selection, Composite parent) throws JavaModelException {
        this.render((IMember)field, parent);
    }

    private void render(IMember element, Composite parent) throws JavaModelException {
        String html = this.findJavadoc(element);
        this.renderJavadoc(html, parent);
    }

    private void render(IPackageFragment element, Composite parent) throws CoreException {
        String html = this.findJavadoc(element);
        this.renderJavadoc(html, parent);
    }

    private void renderJavadoc(final String html, final Composite parent) {
        this.runSyncInUiThread(new Runnable(){

            @Override
            public void run() {
                Browser browser = new Browser(parent, 0);
                browser.setLayoutData((Object)new GridData(1808));
                browser.setText(html);
                browser.addLocationListener(JavaElementLinks.createLocationListener((JavaElementLinks.ILinkHandler)new JavaElementLinks.ILinkHandler(){

                    public void handleDeclarationLink(IJavaElement target) {
                        try {
                            JavaUI.openInEditor((IJavaElement)target);
                        }
                        catch (Exception e) {
                            JavaPlugin.log((Throwable)e);
                        }
                    }

                    public boolean handleExternalLink(URL url, Display display) {
                        try {
                            if (url.getProtocol().equals("file")) {
                                String path = url.getPath();
                                path = StringUtils.removeStart((String)path, (String)"///");
                                path = StringUtils.removeStart((String)path, (String)"/");
                                String type = "L" + StringUtils.substring((String)path, (int)0, (int)(-".html".length()));
                                VmTypeName typeName = VmTypeName.get((String)type);
                                Optional opt = JavadocProvider.this.resolver.toJdtType((ITypeName)typeName);
                                if (opt.isPresent()) {
                                    JavadocProvider.this.workspaceBus.post((Object)new JavaElementSelectionEvent((IJavaElement)opt.get(), JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION));
                                }
                            } else {
                                BrowserUtils.openInDefaultBrowser((URL)url);
                            }
                        }
                        catch (Exception e) {
                            RcpPlugin.logError((Exception)e, (String)"Error during javadoc selection %s", (Object[])new Object[]{url});
                        }
                        return true;
                    }

                    public void handleInlineJavadocLink(IJavaElement target) {
                        JavaElementSelectionEvent.JavaElementSelectionLocation location = JavaElementSelections.resolveSelectionLocationFromJavaElement((IJavaElement)target);
                        JavadocProvider.this.workspaceBus.post((Object)new JavaElementSelectionEvent(target, location));
                    }

                    public void handleJavadocViewLink(IJavaElement target) {
                        this.handleInlineJavadocLink(target);
                    }

                    public void handleTextSet() {
                    }
                }));
            }
        });
    }

    private String findJavadoc(IMember element) throws JavaModelException {
        String html = JavadocContentAccess2.getHTMLContent((IMember)element, (boolean)true);
        return this.extractJavadoc(html);
    }

    private String findJavadoc(IPackageFragment element) throws CoreException {
        String html = JavadocContentAccess2.getHTMLContent((IPackageFragment)element);
        return this.extractJavadoc(html);
    }

    private String extractJavadoc(String html) {
        int max;
        if (html == null) {
            html = Messages.PROVIDER_INTRO_JAVADOC_NOT_FOUND;
        }
        if (html.substring(0, max = Math.min(100, html.length())).indexOf("<html>") != -1) {
            return html;
        }
        StringBuffer info = new StringBuffer(512 + html.length());
        HTMLPrinter.insertPageProlog((StringBuffer)info, (int)0, (String)FG_STYLE_SHEET);
        info.append(html);
        HTMLPrinter.addPageEpilog((StringBuffer)info);
        return info.toString();
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                JavaPlugin.log((Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

