/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.utils.Fingerprints;

public class ModelIndexFingerprintAdvisor
extends AbstractProjectCoordinateAdvisor {
    private final IModelIndex indexer;

    public ModelIndexFingerprintAdvisor(IModelIndex indexer) {
        this.indexer = indexer;
    }

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        String fingerprint = Fingerprints.sha1((File)dependencyInfo.getFile());
        return this.indexer.suggestProjectCoordinateByFingerprint(fingerprint);
    }

    @Override
    protected boolean isApplicable(DependencyType dependencyType) {
        return dependencyType == DependencyType.JAR;
    }
}

