/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetEditor;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetEditorInput;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSnippetHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSnippetHandler.class);
    private Set<ISnippetRepository> repos;
    private ISourceViewer viewer;
    private ITypeRoot root;
    private CompilationUnit ast;
    private ASTNode enclosingNode;
    private IDocument doc;
    private ITextSelection textSelection;
    private int start;
    private int length;
    private char[] text;
    private Set<String> imports;
    private HashMap<IVariableBinding, String> vars;
    private HashMap<String, Integer> lastVarIndex;
    private StringBuilder sb;
    private ExecutionEvent event;

    @Inject
    public CreateSnippetHandler(Set<ISnippetRepository> repos) {
        this.repos = repos;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        CompilationUnitEditor editor = (CompilationUnitEditor)Checks.cast((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event));
        Snippet snippet = this.createSnippet(editor);
        this.openSnippetInEditor(snippet);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    public Snippet createSnippet(CompilationUnitEditor editor) throws ExecutionException {
        this.viewer = editor.getViewer();
        this.root = (ITypeRoot)Checks.cast((Object)editor.getViewPartInput());
        this.ast = SharedASTProvider.getAST((ITypeRoot)this.root, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        this.doc = this.viewer.getDocument();
        this.textSelection = (ITextSelection)Checks.cast((Object)this.viewer.getSelectionProvider().getSelection());
        this.start = this.textSelection.getOffset();
        this.length = this.textSelection.getLength();
        this.text = this.textSelection.getText().toCharArray();
        this.imports = Sets.newTreeSet();
        this.vars = Maps.newHashMap();
        this.lastVarIndex = Maps.newHashMap();
        this.sb = new StringBuilder();
        this.enclosingNode = NodeFinder.perform((ASTNode)this.ast, (int)this.start, (int)this.length);
        selection = Selection.createFromStartLength((int)this.start, (int)this.length);
        i = 0;
        while (i < this.text.length) {
            block16: {
                block15: {
                    ch = this.text[i];
                    if (Character.isJavaIdentifierPart(ch)) break block15;
                    this.sb.append(ch);
                    break block16;
                }
                nodeFinder = new NodeFinder(this.enclosingNode, this.start + i, 0);
                node = nodeFinder.getCoveringNode();
                if (!selection.covers(node)) ** GOTO lbl-1000
                block0 : switch (node.getNodeType()) {
                    case 42: {
                        name = (SimpleName)node;
                        b = name.resolveBinding();
                        if (b != null) {
                            switch (b.getKind()) {
                                case 2: {
                                    tb = (ITypeBinding)b;
                                    this.appendTypeBinding(name, tb);
                                    i += name.getLength() - 1;
                                    break block0;
                                }
                                case 3: {
                                    vb = (IVariableBinding)b;
                                    uniqueVariableName = this.generateUniqueVariableName(vb, name.toString());
                                    locationInParent = name.getLocationInParent();
                                    if (VariableDeclarationFragment.class == locationInParent.getNodeClass() || SingleVariableDeclaration.class == locationInParent.getNodeClass()) {
                                        this.appendNewName(uniqueVariableName, vb);
                                    } else if (selection.covers(this.ast.findDeclaringNode((IBinding)vb))) {
                                        this.appendTemplateVariableReference(uniqueVariableName);
                                    } else if (vb.isField()) {
                                        this.appendVarReference(uniqueVariableName, vb, "field");
                                    } else {
                                        this.appendVarReference(uniqueVariableName, vb, "var");
                                    }
                                    i += name.getLength() - 1;
                                    break block0;
                                }
                            }
                        }
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        this.sb.append(ch);
                    }
                }
            }
            ++i;
        }
        this.sb.append("\n");
        this.appendImports();
        this.appendCursor();
        this.replaceLeadingWhitespaces();
        keywords = Lists.newArrayList();
        tags = Lists.newArrayList();
        return new Snippet(UUID.randomUUID(), "<new snippet>", "<enter description>", (List)keywords, (List)tags, this.sb.toString());
    }

    private String generateUniqueVariableName(IVariableBinding vb, String name) {
        if (this.vars.containsKey(vb)) {
            return this.vars.get(vb);
        }
        String newName = name;
        Integer i = this.lastVarIndex.containsKey(newName) ? this.lastVarIndex.get(newName) : Integer.valueOf(1);
        while (this.vars.containsValue(newName)) {
            i = i + 1;
            newName = name.concat(i.toString());
        }
        this.lastVarIndex.put(name, i);
        this.vars.put(vb, newName);
        return newName;
    }

    private void appendTypeBinding(SimpleName name, ITypeBinding tb) {
        this.sb.append(name);
        this.addImport(tb);
    }

    private void appendNewName(String name, IVariableBinding vb) {
        ITypeBinding type = vb.getType();
        this.sb.append("${").append(name).append(":").append("newName").append("(");
        if (type.isArray()) {
            this.sb.append("'").append(type.getErasure().getQualifiedName()).append("'");
        } else {
            this.sb.append(type.getErasure().getQualifiedName());
        }
        this.sb.append(")").append("}");
        this.addImport(type);
    }

    private StringBuilder appendTemplateVariableReference(String name) {
        return this.sb.append("${").append(name).append("}");
    }

    private void appendVarReference(String name, IVariableBinding vb, String kind) {
        ITypeBinding type = vb.getType();
        this.sb.append("${").append(name).append(":").append(kind).append("(");
        if (type.isArray()) {
            this.sb.append("'").append(type.getErasure().getQualifiedName()).append("'");
        } else {
            this.sb.append(type.getErasure().getQualifiedName());
        }
        this.sb.append(")").append("}");
        this.addImport(type);
    }

    private void appendImports() {
        if (!this.imports.isEmpty()) {
            String joinedTypes = Joiner.on((String)", ").join(this.imports);
            this.sb.append("${:import(").append(joinedTypes).append(")}");
        }
    }

    private void appendCursor() {
        this.sb.append("${cursor}");
    }

    private void addImport(ITypeBinding type) {
        if (type.isArray()) {
            this.addImport(type.getComponentType());
            return;
        }
        if (type.isPrimitive()) {
            return;
        }
        if (type.getPackage().getName().equals("java.lang")) {
            return;
        }
        String name = type.getErasure().getQualifiedName();
        this.imports.add(name);
    }

    private void openSnippetInEditor(Snippet snippet) {
        for (ISnippetRepository r : this.repos) {
            if (!r.isImportSupported()) continue;
            try {
                SnippetEditorInput input = new SnippetEditorInput((ISnippet)snippet, r);
                IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)this.event).getActivePage();
                SnippetEditor ed = (SnippetEditor)((Object)Checks.cast((Object)page.openEditor((IEditorInput)input, "org.eclipse.recommenders.snipmatch.rcp.editors.snippet")));
                ed.setDirty(true);
                return;
            }
            catch (PartInitException e) {
                LOG.error(Messages.ERROR_WHILE_OPENING_EDITOR, (Throwable)e);
            }
        }
        MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.ERROR_NO_EDITABLE_REPO_FOUND, (String)Messages.ERROR_NO_EDITABLE_REPO_FOUND_HINT);
    }

    private void replaceLeadingWhitespaces() {
        try {
            int startLineIndex = this.textSelection.getStartLine();
            int startLineBeginOffset = this.doc.getLineOffset(startLineIndex);
            int startLineEndOffset = this.doc.getLineOffset(startLineIndex + 1) - 1;
            int lineLength = startLineEndOffset - startLineBeginOffset;
            String line = this.doc.get(startLineBeginOffset, lineLength);
            int index = 0;
            while (index < line.length()) {
                if (!Character.isWhitespace(line.charAt(index))) break;
                ++index;
            }
            String wsPrefix = line.substring(0, index);
            String[] code = this.sb.toString().split("\\r?\\n");
            this.sb.setLength(0);
            String[] stringArray = code;
            int n = code.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                String clean = StringUtils.removeStart((String)l, (String)wsPrefix);
                this.sb.append(clean).append(SystemUtils.LINE_SEPARATOR);
                ++n2;
            }
        }
        catch (BadLocationException e) {
            LOG.error("An error occured while determining the leading whitespace characters.", (Throwable)e);
        }
    }
}

