/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.editors;

import com.google.common.base.Strings;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.UUID;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetEditorInput;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetMetadataPage;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetSourcePage;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetSourceValidator;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetEditor
extends FormEditor
implements IResourceChangeListener {
    private static Logger LOG = LoggerFactory.getLogger(SnippetEditor.class);
    private boolean dirty;
    private SnippetMetadataPage metadataEditorPage;
    private SnippetSourcePage sourceEditorPage;

    public SnippetEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        Checks.ensureIsInstanceOf((Object)editorInput, SnippetEditorInput.class);
        this.setPartName(editorInput.getName());
        super.init(site, editorInput);
    }

    protected void addPages() {
        try {
            this.metadataEditorPage = new SnippetMetadataPage(this, "meta", Messages.EDITOR_PAGE_NAME_METADATA);
            this.addPage((IFormPage)this.metadataEditorPage);
            this.sourceEditorPage = new SnippetSourcePage(this, "source", Messages.EDITOR_PAGE_NAME_SOURCE);
            this.addPage((IFormPage)this.sourceEditorPage);
        }
        catch (PartInitException e) {
            LOG.error("Exception while adding editor pages.", (Throwable)e);
        }
    }

    public void setDirty(boolean newDirty) {
        if (this.dirty != newDirty) {
            this.dirty = newDirty;
            this.editorDirtyStateChanged();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        SnippetEditorInput input = (SnippetEditorInput)this.getEditorInput();
        Snippet snippet = input.getSnippet();
        ISnippetRepository repo = input.getRepository();
        if (repo == null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DIALOG_TITLE_ERROR_WHILE_STORING_SNIPPET, (String)Messages.DIALOG_MESSAGE_NO_REPOSITORY_AVAILABLE);
            monitor.setCanceled(true);
            return;
        }
        if (Strings.isNullOrEmpty((String)snippet.getName())) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DIALOG_TITLE_INAVLID_SNIPPET_NAME, (String)Messages.DIALOG_MESSAGE_INVALID_SNIPPET_NAME);
            monitor.setCanceled(true);
            return;
        }
        String sourceValid = SnippetSourceValidator.isSourceValid(snippet.getCode());
        if (!sourceValid.isEmpty()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DIALOG_TITLE_ERROR_SNIPPET_SOURCE_INVALID, (String)MessageFormat.format(Messages.DIALOG_MESSAGE_ERROR_SNIPPET_SOURCE_INVALID, sourceValid));
            monitor.setCanceled(true);
            return;
        }
        ISnippet oldSnippet = input.getOldSnippet();
        if (!oldSnippet.getCode().isEmpty() && !snippet.getCode().equals(oldSnippet.getCode())) {
            int status = new MessageDialog(this.getSite().getShell(), Messages.DIALOG_TITLE_SAVE_SNIPPET, null, Messages.DIALOG_MESSAGE_SAVE_SNIPPET_WITH_MODIFIED_CODE, 3, new String[]{Messages.DIALOG_OPTION_SAVE, Messages.DIALOG_OPTION_SAVE_AS_NEW, Messages.DIALOG_OPTION_CANCEL}, 0).open();
            if (status == 1) {
                snippet.setUUID(UUID.randomUUID());
                this.setInput(new SnippetEditorInput((ISnippet)snippet, input.getRepository()));
                this.updateEditorPages();
            }
            if (status == 2) {
                monitor.setCanceled(true);
                return;
            }
            if (status == -1) {
                monitor.setCanceled(true);
                return;
            }
        }
        try {
            input.setOldSnippet(Snippet.copy((ISnippet)snippet));
            repo.importSnippet((ISnippet)snippet);
            this.setPartName(this.getEditorInput().getName());
            this.setDirty(false);
        }
        catch (IOException e) {
            LOG.error("Exception while storing snippet.", (Throwable)e);
        }
    }

    private void updateEditorPages() {
        this.metadataEditorPage.init(this.getEditorSite(), this.getEditorInput());
        this.sourceEditorPage.init(this.getEditorSite(), this.getEditorInput());
        this.metadataEditorPage.update();
        this.sourceEditorPage.update();
    }

    public void doSaveAs() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }
}

