/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import com.google.common.base.Optional;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.recommenders.rcp.utils.MatchingUtils;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class ProposalMatcher {
    private final IMethodName proposedMethod;

    public ProposalMatcher(CompletionProposal proposal, Optional<TypeBinding> receiverTypeBinding) {
        this.proposedMethod = MatchingUtils.asMethodName((CompletionProposal)proposal, receiverTypeBinding);
    }

    public boolean match(IMethodName rMethod) {
        String rName = rMethod.getName();
        ITypeName[] rParams = rMethod.getParameterTypes();
        if (!rName.equals(this.proposedMethod.getName())) {
            return false;
        }
        ITypeName[] parameterTypes = this.proposedMethod.getParameterTypes();
        if (rParams.length != parameterTypes.length) {
            return false;
        }
        int i = rParams.length;
        while (i-- > 0) {
            if (rParams[i].equals(parameterTypes[i])) continue;
            return false;
        }
        return true;
    }
}

