/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Joiner;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.recommenders.internal.models.rcp.Dialogs;
import org.eclipse.recommenders.internal.models.rcp.Messages;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ModelsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ModelRepositoryListEditor repoEditor;

    public ModelsPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.models.rcp"));
        this.setMessage(Messages.PREFPAGE_TITLE_MODEL_REPOSITORIES);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION_MODEL_REPOSITORIES);
    }

    protected void createFieldEditors() {
        this.repoEditor = new ModelRepositoryListEditor("repository.url.list", Messages.FIELD_LABEL_REPOSITORY_URIS, this.getFieldEditorParent());
        this.addField((FieldEditor)this.repoEditor);
        this.addField((FieldEditor)new BooleanFieldEditor("repository.auto.download", Messages.FIELD_LABEL_ENABLE_AUTO_DOWNLOAD, this.getFieldEditorParent()));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        String repositoryURLList = Joiner.on((String)"\t").join((Object[])this.repoEditor.getItems());
        store.setValue("repository.url.list", repositoryURLList);
        return super.performOk();
    }

    private final class ModelRepositoryListEditor
    extends ListEditor {
        private ModelRepositoryListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean hasMoreThanOneUrl = ModelRepositoryListEditor.this.getList().getItems().length > 1;
                    ModelRepositoryListEditor.this.getRemoveButton().setEnabled(hasMoreThanOneUrl);
                }
            });
        }

        public String[] getItems() {
            return super.getList().getItems();
        }

        protected String[] parseString(String stringList) {
            return ModelsRcpPreferences.splitRemoteRepositoryString(stringList);
        }

        protected String getNewInputObject() {
            InputDialog inputDialog = Dialogs.newModelRepositoryUrlDialog(this.getShell(), this.getItems());
            if (inputDialog.open() == 0) {
                return inputDialog.getValue();
            }
            return null;
        }

        protected String createList(String[] items) {
            return ModelsRcpPreferences.joinRemoteRepositoriesToString(items);
        }
    }
}

