/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.rcp.advisors;

import com.google.common.base.Optional;
import java.net.URI;
import java.net.URL;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.IProjectCoordinateAdvisor;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.MavenCentralFingerprintSearchAdvisor;
import org.eclipse.recommenders.utils.Urls;

public class EclipseMavenCentralFingerprintSearchAdvisor
implements IProjectCoordinateAdvisor {
    private static final URI SEARCH_MAVEN_ORG_URI = Urls.toUri((URL)MavenCentralFingerprintSearchAdvisor.SEARCH_MAVEN_ORG);
    private static final int DEFAULT_PROXY_PORT = 80;
    private final MavenCentralFingerprintSearchAdvisor delegate;
    private final IProxyService proxy;
    private ProxyConfig proxyConfig;

    @Inject
    public EclipseMavenCentralFingerprintSearchAdvisor(IProxyService proxy) {
        this.proxy = proxy;
        ProxyConfig newProxyConfig = this.updateProxyConfig();
        this.delegate = new MavenCentralFingerprintSearchAdvisor(newProxyConfig.host, newProxyConfig.port, newProxyConfig.user, newProxyConfig.password);
    }

    public Optional<ProjectCoordinate> suggest(DependencyInfo dependencyInfo) {
        ProxyConfig updatedProxyConfig = this.updateProxyConfig();
        if (updatedProxyConfig != null) {
            this.delegate.setProxy(updatedProxyConfig.host, updatedProxyConfig.port, updatedProxyConfig.user, updatedProxyConfig.password);
        }
        return this.delegate.suggest(dependencyInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyConfig updateProxyConfig() {
        String currentProxyUser;
        String currentProxyPassword;
        int currentProxyPort;
        String currentProxyHost;
        IProxyService iProxyService = this.proxy;
        synchronized (iProxyService) {
            if (!this.proxy.isProxiesEnabled()) {
                currentProxyHost = null;
                currentProxyPort = -1;
                currentProxyPassword = null;
                currentProxyUser = null;
            } else {
                IProxyData[] entries = this.proxy.select(SEARCH_MAVEN_ORG_URI);
                if (entries.length == 0) {
                    currentProxyHost = null;
                    currentProxyPort = -1;
                    currentProxyPassword = null;
                    currentProxyUser = null;
                } else {
                    IProxyData proxyData = entries[0];
                    currentProxyHost = proxyData.getHost();
                    currentProxyPort = proxyData.getPort() != -1 ? proxyData.getPort() : 80;
                    currentProxyUser = proxyData.getUserId();
                    currentProxyPassword = proxyData.getPassword();
                }
            }
        }
        if (this.proxyConfig == null || !this.proxyConfig.isEqualTo(currentProxyHost, currentProxyPort, currentProxyUser, currentProxyPassword)) {
            this.proxyConfig = new ProxyConfig(currentProxyHost, currentProxyPort, currentProxyUser, currentProxyPassword);
            return this.proxyConfig;
        }
        return null;
    }

    private static class ProxyConfig {
        private final String host;
        private final int port;
        private final String user;
        private final String password;

        public ProxyConfig(String host, int port, String user, String password) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.password = password;
        }

        public boolean isEqualTo(String proxyHost, int proxyPort, String proxyUser, String proxyPassword) {
            return StringUtils.equals((CharSequence)this.host, (CharSequence)proxyHost) && this.port == proxyPort && StringUtils.equals((CharSequence)this.user, (CharSequence)proxyUser) && StringUtils.equals((CharSequence)this.password, (CharSequence)proxyPassword);
        }
    }
}

