/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.recommenders.internal.rcp.RcpPlugin;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchTemplateContextType;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposal;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class SnipmatchContentAssistProcessor
implements IContentAssistProcessor {
    private final Set<ISnippetRepository> repos;
    private final TemplateContextType contextType;
    private final Image image;
    private JavaContentAssistInvocationContext ctx;
    private String terms;

    @Inject
    public SnipmatchContentAssistProcessor(Set<ISnippetRepository> repos, SharedImages images) {
        this.repos = repos;
        this.contextType = SnipmatchTemplateContextType.getInstance();
        this.image = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_BULLET_BLUE);
    }

    public void setContext(JavaContentAssistInvocationContext ctx) {
        this.ctx = ctx;
    }

    public void setTerms(String query) {
        this.terms = query;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (StringUtils.isEmpty((CharSequence)this.terms)) {
            return new ICompletionProposal[0];
        }
        LinkedList proposals = Lists.newLinkedList();
        ArrayList recommendations = Lists.newArrayList();
        for (ISnippetRepository repo : this.repos) {
            recommendations.addAll(repo.search(this.terms));
        }
        ICompilationUnit cu = this.ctx.getCompilationUnit();
        IEditorPart editor = EditorUtility.isOpenInEditor((Object)cu);
        ISourceViewer sourceViewer = (ISourceViewer)editor.getAdapter(ITextOperationTarget.class);
        Point selection = sourceViewer.getSelectedRange();
        Region region = new Region(selection.x, selection.y);
        Position p = new Position(selection.x, selection.y);
        IDocument document = sourceViewer.getDocument();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        JavaContext ctx = new JavaContext(this.contextType, document, p, cu);
        ctx.setVariable("selection", selectedText);
        for (Recommendation recommendation : recommendations) {
            ISnippet snippet = (ISnippet)recommendation.getProposal();
            Template template = new Template(snippet.getName(), snippet.getDescription(), "Snipmatch-Java-Context", snippet.getCode(), true);
            try {
                proposals.add(SnippetProposal.newSnippetProposal((Recommendation<ISnippet>)recommendation, template, (TemplateContext)ctx, (IRegion)region, this.image));
            }
            catch (Exception e) {
                RcpPlugin.logError((Exception)e, (String)"org.eclipse.recommenders.snipmatch.rcp", (Object[])new Object[]{Messages.ERROR_CREATING_SNIPPET_PROPOSAL_FAILED});
            }
        }
        return (ICompletionProposal[])Iterables.toArray((Iterable)proposals, ICompletionProposal.class);
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }
}

