/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.internal.ui.text.java.RelevanceSorter;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateInformationControlCreator;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchContentAssistProcessor;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetAppliedEvent;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposal;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SnipmatchCompletionEngine {
    private static final int SEARCH_BOX_WIDTH = 273;
    private final SnipmatchContentAssistProcessor processor;
    private final EventBus bus;
    private final ColorRegistry colorRegistry;
    private final FontRegistry fontRegistry;
    private final ContentAssistant assistant;
    private Shell searchShell;
    private JavaContentAssistInvocationContext ctx;
    private TemplateProposal selectedProposal;
    private StyledText searchText;
    private Color searchBg;
    private Font searchFont;

    @Inject
    public SnipmatchCompletionEngine(SnipmatchContentAssistProcessor processor, EventBus bus, ColorRegistry colorRegistry, FontRegistry fontRegistry) {
        this.processor = processor;
        this.bus = bus;
        this.colorRegistry = colorRegistry;
        this.fontRegistry = fontRegistry;
        this.assistant = this.newContentAssistant();
    }

    private ContentAssistant newContentAssistant() {
        ContentAssistant assistant = new ContentAssistant();
        assistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                if (SnipmatchCompletionEngine.this.searchShell != null && !SnipmatchCompletionEngine.this.searchShell.isDisposed()) {
                    SnipmatchCompletionEngine.this.searchShell.setVisible(false);
                    SnipmatchCompletionEngine.this.searchShell.dispose();
                }
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                if (proposal instanceof TemplateProposal) {
                    SnipmatchCompletionEngine.this.selectedProposal = (TemplateProposal)proposal;
                } else {
                    SnipmatchCompletionEngine.this.selectedProposal = null;
                }
            }

            public void assistSessionStarted(ContentAssistEvent event) {
            }
        });
        assistant.setShowEmptyList(true);
        assistant.enablePrefixCompletion(true);
        assistant.enableColoredLabels(true);
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator((IInformationControlCreator)new TemplateInformationControlCreator(0x2000000));
        assistant.setEmptyMessage(Messages.COMPLETION_ENGINE_NO_SNIPPETS_FOUND);
        assistant.setRepeatedInvocationMode(true);
        assistant.setStatusLineVisible(true);
        assistant.setSorter((ICompletionProposalSorter)new RelevanceSorter());
        return assistant;
    }

    public void show(JavaContentAssistInvocationContext ctx) {
        this.ctx = ctx;
        this.processor.setContext(ctx);
        this.assistant.install(ctx.getViewer());
        this.createSearchPopup();
    }

    private void createSearchPopup() {
        Shell parentShell = this.ctx.getViewer().getTextWidget().getShell();
        this.searchShell = new Shell(parentShell, 16384);
        this.searchBg = this.colorRegistry.get("org.eclipse.recommenders.snipmatch.rcp.searchboxbackground");
        this.searchFont = this.fontRegistry.get("org.eclipse.recommenders.snipmatch.rcp.searchTextFont");
        this.searchShell.setLayout((Layout)new FillLayout());
        this.searchShell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    SnipmatchCompletionEngine.this.assistant.uninstall();
                }
            }
        });
        this.searchText = new StyledText((Composite)this.searchShell, 2048);
        this.searchText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SnipmatchCompletionEngine.this.searchShell.dispose();
            }
        });
        this.searchText.setBackground(this.searchBg);
        this.searchText.setFont(this.searchFont);
        this.searchText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                switch (e.character) {
                    case '\r': {
                        e.doit = false;
                        if (SnipmatchCompletionEngine.this.selectedProposal != null) {
                            SnipmatchCompletionEngine.this.assistant.uninstall();
                            if (SnipmatchCompletionEngine.this.selectedProposal.isValidFor(SnipmatchCompletionEngine.this.ctx.getDocument(), SnipmatchCompletionEngine.this.ctx.getInvocationOffset())) {
                                if (SnipmatchCompletionEngine.this.selectedProposal instanceof SnippetProposal) {
                                    SnipmatchCompletionEngine.this.snippetApplied((SnippetProposal)SnipmatchCompletionEngine.this.selectedProposal);
                                }
                                SnipmatchCompletionEngine.this.selectedProposal.apply(SnipmatchCompletionEngine.this.ctx.getViewer(), '\u0000', 0, SnipmatchCompletionEngine.this.ctx.getInvocationOffset());
                                Point selection = SnipmatchCompletionEngine.this.selectedProposal.getSelection(SnipmatchCompletionEngine.this.ctx.getDocument());
                                if (selection != null) {
                                    SnipmatchCompletionEngine.this.ctx.getViewer().setSelectedRange(selection.x, selection.y);
                                    SnipmatchCompletionEngine.this.ctx.getViewer().revealRange(selection.x, selection.y);
                                }
                            }
                        }
                        return;
                    }
                    case '\t': {
                        e.doit = false;
                        return;
                    }
                }
                switch (e.keyCode) {
                    case 0x1000001: {
                        this.execute("org.eclipse.ui.edit.text.contentAssist.selectPreviousProposal");
                        return;
                    }
                    case 0x1000002: {
                        this.execute("org.eclipse.ui.edit.text.contentAssist.selectNextProposal");
                        return;
                    }
                }
            }

            private void execute(String commandId) {
                try {
                    SnipmatchCompletionEngine.this.assistant.getHandler(commandId).execute(null);
                }
                catch (ExecutionException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String query = SnipmatchCompletionEngine.this.searchText.getText().trim();
                SnipmatchCompletionEngine.this.processor.setTerms(query);
                SnipmatchCompletionEngine.this.assistant.showPossibleCompletions();
                SnipmatchCompletionEngine.this.assistant.showContextInformation();
            }
        });
        Point anchor = this.computeSearchShellPosition();
        this.searchShell.setLocation(anchor.x, anchor.y);
        this.configureShellSize();
        this.searchShell.open();
        this.searchShell.setFocus();
    }

    private void configureShellSize() {
        this.searchShell.pack();
        this.searchShell.setSize(273, this.searchShell.getSize().y);
    }

    private Point computeSearchShellPosition() {
        StyledText styledText = this.ctx.getViewer().getTextWidget();
        Caret caret = styledText.getCaret();
        Point location = caret.getLocation();
        return styledText.toDisplay(location.x, location.y - 2);
    }

    private void snippetApplied(SnippetProposal proposal) {
        ISnippet snippet = proposal.getSnippet();
        String repoUri = null;
        this.bus.post((Object)new SnippetAppliedEvent(snippet.getUuid(), repoUri));
    }
}

