/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.names.IMethodName;

@Beta
public class Recommendations {
    private static final Comparator<Recommendation<?>> C_BY_RELEVANCE = new Comparator<Recommendation<?>>(){

        @Override
        public int compare(Recommendation<?> o1, Recommendation<?> o2) {
            return ComparisonChain.start().compare(o1.getRelevance(), o2.getRelevance()).compare((Comparable)((Object)o1.toString()), (Comparable)((Object)o2.toString())).result();
        }
    };
    private static final Comparator<Recommendation<?>> C_BY_NAME = new Comparator<Recommendation<?>>(){

        @Override
        public int compare(Recommendation<?> o1, Recommendation<?> o2) {
            return ComparisonChain.start().compare((Comparable)((Object)o1.getProposal().toString()), (Comparable)((Object)o2.getProposal().toString())).result();
        }
    };
    private static final Predicate<Recommendation<IMethodName>> P_VOID = new Predicate<Recommendation<IMethodName>>(){

        public boolean apply(Recommendation<IMethodName> input) {
            return !input.getProposal().isVoid();
        }
    };

    private static Predicate<Recommendation<?>> newMinimumRelevancePredicate(final double min) {
        return new Predicate<Recommendation<?>>(){

            public boolean apply(Recommendation<?> input) {
                return input.getRelevance() >= min;
            }
        };
    }

    public static <R extends Recommendation<T>, T> List<R> top(Iterable<R> recommendations, int numberOfTopElements) {
        return Ordering.from(C_BY_RELEVANCE).greatestOf(recommendations, numberOfTopElements);
    }

    public static <R extends Recommendation<T>, T> List<R> top(Iterable<R> recommendations, int numberOfTopElements, double minRelevance) {
        return Ordering.from(C_BY_RELEVANCE).greatestOf(Recommendations.filterRelevance(recommendations, minRelevance), numberOfTopElements);
    }

    public static Iterable<Recommendation<IMethodName>> filterVoid(Iterable<Recommendation<IMethodName>> recommendations) {
        return Iterables.filter(recommendations, P_VOID);
    }

    public static <R extends Recommendation<T>, T> Iterable<R> filterRelevance(Iterable<R> recommendations, double min) {
        return Iterables.filter(recommendations, Recommendations.newMinimumRelevancePredicate(min));
    }

    public static <R extends Recommendation<T>, T> List<R> sortByName(Iterable<R> recommendations) {
        return Ordering.from(C_BY_NAME).sortedCopy(recommendations);
    }

    public static <R extends Recommendation<T>, T> List<R> sortByRelevance(Iterable<R> recommendations) {
        return Ordering.from(C_BY_RELEVANCE).reverse().sortedCopy(recommendations);
    }

    public static int asPercentage(Recommendation<?> recommendation) {
        double rel = recommendation.getRelevance();
        Checks.ensureIsInRange(rel, 0.0, 1.0, "relevance '%f' not in interval [0, 1]", rel);
        return (int)Math.round(rel * 100.0);
    }

    public static <R extends Recommendation<T>, T> List<T> getProposals(Iterable<R> recommendations) {
        LinkedList res = Lists.newLinkedList();
        for (Recommendation rec : recommendations) {
            res.add(rec.getProposal());
        }
        return res;
    }

    public static <R extends Recommendation<T>, T> Map<T, Double> asMap(Iterable<R> recommendations) {
        HashMap res = Maps.newHashMap();
        for (Recommendation rec : recommendations) {
            res.put(rec.getProposal(), rec.getRelevance());
        }
        return res;
    }
}

