/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import com.google.common.base.Optional;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.recommenders.rcp.utils.MatchingUtils;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class ProposalMatcher {
    private final Optional<IMethodName> proposedMethod;

    public ProposalMatcher(CompletionProposal proposal, Optional<TypeBinding> receiverTypeBinding) {
        this.proposedMethod = Optional.fromNullable((Object)MatchingUtils.asMethodName((CompletionProposal)proposal, receiverTypeBinding));
    }

    public boolean match(IMethodName candidate) {
        IMethodName method = (IMethodName)this.proposedMethod.orNull();
        if (method == null) {
            return false;
        }
        String candidateName = candidate.getName();
        if (!candidateName.equals(method.getName())) {
            return false;
        }
        ITypeName[] params = method.getParameterTypes();
        ITypeName[] candidateParams = candidate.getParameterTypes();
        if (candidateParams.length != params.length) {
            return false;
        }
        int i = candidateParams.length;
        while (i-- > 0) {
            if (candidateParams[i].equals(params[i])) continue;
            return false;
        }
        return true;
    }
}

