/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.overrides;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.jtree.JunctionTreeAlgorithm;
import org.eclipse.recommenders.overrides.IOverrideModel;
import org.eclipse.recommenders.overrides.JayesOverrideModelBuilder;
import org.eclipse.recommenders.overrides.OverrideObservation;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;

public class JayesOverrideModel
implements IOverrideModel {
    private JunctionTreeAlgorithm junctionTreeAlgorithm;
    private ITypeName typeName;
    private BayesNode patternNode;
    private HashMap<IMethodName, BayesNode> methodNodes;

    public static Optional<IOverrideModel> load(ZipFile zip, ITypeName type) throws IOException {
        Type listType;
        String path = Zips.path((ITypeName)type, (String)".json");
        ZipEntry entry = zip.getEntry(path);
        if (entry == null) {
            return Optional.absent();
        }
        InputStream is = zip.getInputStream(entry);
        List observations = (List)GsonUtil.deserialize((InputStream)is, (Type)(listType = new TypeToken<List<OverrideObservation>>(){}.getType()));
        if (observations.size() == 0) {
            observations.add(new OverrideObservation());
        }
        JayesOverrideModelBuilder b = new JayesOverrideModelBuilder(type, observations);
        IOverrideModel network = b.build();
        return Optional.of((Object)network);
    }

    protected JayesOverrideModel(ITypeName typeName, BayesNet network, BayesNode patternNode, List<BayesNode> methodNodes) {
        this.typeName = typeName;
        this.patternNode = patternNode;
        this.junctionTreeAlgorithm = new JunctionTreeAlgorithm();
        this.junctionTreeAlgorithm.setNetwork(network);
        this.createMethodNameMapping(methodNodes);
    }

    private void createMethodNameMapping(List<BayesNode> methods) {
        this.methodNodes = Maps.newHashMap();
        for (BayesNode methodNode : methods) {
            this.methodNodes.put((IMethodName)VmMethodName.get((String)methodNode.getName()), methodNode);
        }
    }

    @Override
    public void reset() {
        this.junctionTreeAlgorithm.setEvidence(new HashMap());
    }

    @Override
    public ITypeName getType() {
        return this.typeName;
    }

    @Override
    public ImmutableSet<String> getKnownPatterns() {
        return ImmutableSet.copyOf((Collection)this.patternNode.getOutcomes());
    }

    @Override
    public ImmutableSet<IMethodName> getKnownMethods() {
        return ImmutableSet.copyOf(this.methodNodes.keySet());
    }

    @Override
    public void setObservedMethod(IMethodName methodName) {
        BayesNode methodNode = this.methodNodes.get(methodName);
        if (methodNode != null) {
            this.junctionTreeAlgorithm.addEvidence(methodNode, "true");
        }
    }

    @Override
    public List<Recommendation<IMethodName>> recommendOverrides() {
        LinkedList recommendations = Lists.newLinkedList();
        for (BayesNode node : this.methodNodes.values()) {
            if (this.junctionTreeAlgorithm.getEvidence().containsKey(node)) continue;
            double probability = this.junctionTreeAlgorithm.getBeliefs(node)[0];
            VmMethodName method = VmMethodName.get((String)node.getName());
            recommendations.add(Recommendation.newRecommendation((Object)method, (double)probability));
        }
        return recommendations;
    }

    public String toString() {
        return String.format("Model for '%s'", this.typeName);
    }
}

