/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import java.lang.reflect.Field;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class MatchingUtils {
    private static final String[] NO_TYPE_PARAMETERS = new String[0];
    private static Field fOriginalSignature;

    static {
        try {
            fOriginalSignature = InternalCompletionProposal.class.getDeclaredField("originalSignature");
            fOriginalSignature.setAccessible(true);
        }
        catch (Exception exception) {}
    }

    private static boolean canUseReflection(CompletionProposal proposal) {
        return proposal instanceof InternalCompletionProposal && fOriginalSignature != null && fOriginalSignature.isAccessible();
    }

    public static IMethodName asMethodName(CompletionProposal proposal, Optional<TypeBinding> receiverTypeBinding) {
        String jSignature = MatchingUtils.getSignature(proposal);
        String declarationSignature = String.valueOf(proposal.getDeclarationSignature());
        String name = String.valueOf(proposal.getName());
        String[] parameterTypes = Signature.getParameterTypes((String)jSignature);
        String[] methodTypeParameters = Signature.getTypeParameters((String)jSignature);
        String returnTypeSignature = Signature.getReturnType((String)jSignature);
        String[] classTypeParameters = MatchingUtils.extractClassTypeParameters(receiverTypeBinding = MatchingUtils.resolveTypeVariable(receiverTypeBinding));
        ITypeName elementType = MatchingUtils.asTypeName(declarationSignature, methodTypeParameters, classTypeParameters);
        if (elementType == null) {
            return null;
        }
        ITypeName[] params = new ITypeName[parameterTypes.length];
        int i = 0;
        while (i < params.length) {
            ITypeName param = MatchingUtils.asTypeName(parameterTypes[i], methodTypeParameters, classTypeParameters);
            if (param == null) {
                return null;
            }
            params[i] = param;
            ++i;
        }
        ITypeName returnType = MatchingUtils.asTypeName(returnTypeSignature, methodTypeParameters, classTypeParameters);
        if (returnType == null) {
            return null;
        }
        return MatchingUtils.createMethodName(elementType, name, params, returnType);
    }

    private static Optional<TypeBinding> resolveTypeVariable(Optional<TypeBinding> typeBinding) {
        if (typeBinding.isPresent() && ((TypeBinding)typeBinding.get()).isTypeVariable() && typeBinding.get() instanceof TypeVariableBinding) {
            TypeVariableBinding typeVariableBinding = (TypeVariableBinding)typeBinding.get();
            typeBinding = Optional.of((Object)typeVariableBinding.firstBound);
        }
        return typeBinding;
    }

    public static String[] extractClassTypeParameters(Optional<TypeBinding> receiverTypeBinding) {
        TypeVariableBinding[] typeVariableBindings;
        if (!receiverTypeBinding.isPresent()) {
            return NO_TYPE_PARAMETERS;
        }
        TypeBinding typeBinding = (TypeBinding)receiverTypeBinding.get();
        if (typeBinding instanceof ParameterizedTypeBinding) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
            typeVariableBindings = parameterizedTypeBinding.genericType().typeVariables();
        } else if (typeBinding instanceof TypeVariableBinding) {
            typeVariableBindings = new TypeVariableBinding[]{(TypeVariableBinding)typeBinding};
        } else {
            return NO_TYPE_PARAMETERS;
        }
        String[] classTypeParameters = new String[typeVariableBindings.length];
        int i = 0;
        while (i < classTypeParameters.length) {
            TypeVariableBinding typeVariableBinding = typeVariableBindings[i];
            classTypeParameters[i] = String.valueOf(typeVariableBinding.genericSignature());
            ++i;
        }
        return classTypeParameters;
    }

    public static ITypeName asTypeName(String typeSignature, String[] primaryTypeParameters, String[] secondaryTypeParameters) {
        int signatureKind = Signature.getTypeSignatureKind((String)typeSignature);
        switch (signatureKind) {
            case 4: {
                int arrayCount = Signature.getArrayCount((String)typeSignature);
                return VmTypeName.get((String)(String.valueOf(StringUtils.repeat((char)'[', (int)arrayCount)) + MatchingUtils.asTypeName(Signature.getElementType((String)typeSignature), primaryTypeParameters, secondaryTypeParameters).getIdentifier()));
            }
            case 1: {
                String erasedTypedSignature = Signature.getTypeErasure((String)typeSignature);
                return VmTypeName.get((String)StringUtils.removeEnd((String)erasedTypedSignature.replace('.', '/'), (String)";"));
            }
            case 2: {
                return VmTypeName.get((String)typeSignature);
            }
            case 3: {
                String identifier = StringUtils.substring((String)typeSignature, (int)1, (int)(typeSignature.length() - 1));
                ITypeName typeParameter = MatchingUtils.locateTypeParameter(identifier, primaryTypeParameters, secondaryTypeParameters);
                if (typeParameter == null) {
                    typeParameter = MatchingUtils.locateTypeParameter(identifier, secondaryTypeParameters, NO_TYPE_PARAMETERS);
                }
                return typeParameter;
            }
            case 5: {
                return null;
            }
            case 6: {
                return null;
            }
            case 7: {
                return null;
            }
        }
        return null;
    }

    private static ITypeName locateTypeParameter(String identifier, String[] primaryTypeParameters, String[] secondaryTypeParameters) {
        int i = 0;
        while (i < primaryTypeParameters.length) {
            String typeVariable;
            String primaryTypeParameter = primaryTypeParameters[i];
            if (primaryTypeParameter != null && (typeVariable = Signature.getTypeVariable((String)primaryTypeParameter)).equals(identifier)) {
                String[] typeParameterBounds = Signature.getTypeParameterBounds((String)primaryTypeParameter);
                if (typeParameterBounds.length == 0) {
                    return VmTypeName.OBJECT;
                }
                return MatchingUtils.asTypeName(typeParameterBounds[0], primaryTypeParameters, secondaryTypeParameters);
            }
            ++i;
        }
        return null;
    }

    public static String getSignature(CompletionProposal proposal) {
        try {
            char[] s;
            if (MatchingUtils.canUseReflection(proposal) && (s = (char[])fOriginalSignature.get(proposal)) != null) {
                return String.valueOf(s);
            }
        }
        catch (Exception exception) {}
        return String.valueOf(proposal.getSignature());
    }

    private static IMethodName createMethodName(ITypeName elementType, String name, ITypeName[] parameterTypes, ITypeName returnType) {
        StringBuilder builder = new StringBuilder();
        builder.append(elementType.getIdentifier());
        builder.append(".");
        builder.append(name);
        builder.append("(");
        ITypeName[] iTypeNameArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeName parameterType = iTypeNameArray[n2];
            builder.append(parameterType.getIdentifier());
            if (!parameterType.isPrimitiveType()) {
                builder.append(";");
            }
            ++n2;
        }
        builder.append(")");
        builder.append(returnType);
        if (!returnType.isPrimitiveType()) {
            builder.append(";");
        }
        return VmMethodName.get((String)builder.toString());
    }
}

