/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.internal.calls.rcp.AstDefUseFinder;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.names.IMethodName;

public class CallCompletionContextFunctions {
    public static final CompletionContextKey<IType> RECEIVER_TYPE2 = new CompletionContextKey();
    public static final CompletionContextKey<IMethodName> RECEIVER_DEF_BY = new CompletionContextKey();
    public static final CompletionContextKey<List<IMethodName>> RECEIVER_CALLS = new CompletionContextKey();
    public static final CompletionContextKey<ICallModel.DefinitionKind> RECEIVER_DEF_TYPE = new CompletionContextKey();

    public static Map<CompletionContextKey, ICompletionContextFunction> registerDefaults(Map<CompletionContextKey, ICompletionContextFunction> functions) {
        ReceiverCallsCompletionContextFunction f = new ReceiverCallsCompletionContextFunction();
        functions.put(RECEIVER_CALLS, f);
        functions.put(RECEIVER_DEF_BY, f);
        functions.put(RECEIVER_DEF_TYPE, f);
        functions.put(RECEIVER_TYPE2, new ReceiverTypeContextFunction());
        return functions;
    }

    public static class ReceiverCallsCompletionContextFunction
    implements ICompletionContextFunction {
        public Object compute(IRecommendersCompletionContext context, CompletionContextKey key) {
            List<IMethodName> calls = null;
            ICallModel.DefinitionKind defType = null;
            IMethodName defBy = null;
            MethodDeclaration method = (MethodDeclaration)context.get(CompletionContextKey.ENCLOSING_AST_METHOD, null);
            if (method != null) {
                String receiverName = (String)context.get(CompletionContextKey.RECEIVER_NAME, null);
                AstDefUseFinder f = new AstDefUseFinder(receiverName, method);
                calls = f.getCalls();
                defType = f.getDefinitionKind();
                defBy = (IMethodName)f.getDefiningMethod().orNull();
                if (defType == ICallModel.DefinitionKind.UNKNOWN) {
                    IMethodName def = (IMethodName)context.getMethodDef().orNull();
                    if (def == null) {
                        defType = receiverName.isEmpty() ? ICallModel.DefinitionKind.THIS : ICallModel.DefinitionKind.FIELD;
                    } else if (def.isInit()) {
                        defType = ICallModel.DefinitionKind.NEW;
                        defBy = def;
                    } else {
                        defType = ICallModel.DefinitionKind.RETURN;
                        defBy = def;
                    }
                }
            }
            context.set(RECEIVER_CALLS, calls);
            context.set(RECEIVER_DEF_TYPE, defType);
            context.set(RECEIVER_DEF_BY, defBy);
            return context.get(key).orNull();
        }
    }

    public static class ReceiverTypeContextFunction
    implements ICompletionContextFunction<Object> {
        public Object compute(IRecommendersCompletionContext context, CompletionContextKey<Object> key) {
            IType receiverType = null;
            try {
                receiverType = this.findReceiver(context);
            }
            catch (Exception exception) {}
            context.set(RECEIVER_TYPE2, (Object)receiverType);
            return receiverType;
        }

        private IType findReceiver(IRecommendersCompletionContext context) throws Exception {
            IType receiverType = (IType)context.getReceiverType().orNull();
            String receiverName = context.getReceiverName();
            if (this.isExplicitThis(receiverName) || this.isImplicitThis(receiverType, receiverName)) {
                String superclassTypeSignature;
                IMethod m = (IMethod)context.getEnclosingMethod().orNull();
                if (m == null || JdtFlags.isStatic((IMember)m)) {
                    return receiverType;
                }
                IType type = m.getDeclaringType();
                ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
                receiverType = hierarchy.getSuperclass(type);
                if (receiverType == null && (superclassTypeSignature = type.getSuperclassTypeSignature()) != null) {
                    receiverType = (IType)JdtUtils.findTypeFromSignature((String)superclassTypeSignature, (IJavaElement)type).orNull();
                }
            }
            return receiverType;
        }

        private boolean isImplicitThis(IType receiverType, String receiverName) {
            return receiverType == null && StringUtils.isEmpty((CharSequence)receiverName);
        }

        private boolean isExplicitThis(String receiverName) {
            return "this".equals(receiverName);
        }
    }
}

