/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import com.google.common.base.Optional;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.calls.PoolingCallModelProvider;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.IRcpService;

public class RcpCallModelProvider
implements ICallModelProvider,
IRcpService {
    private final IModelRepository repository;
    private final IModelArchiveCoordinateAdvisor index;
    private ICallModelProvider delegate;

    @Inject
    public RcpCallModelProvider(IModelRepository repository, IModelArchiveCoordinateAdvisor index) {
        this.repository = repository;
        this.index = index;
    }

    @PostConstruct
    public void open() throws IOException {
        this.delegate = new PoolingCallModelProvider(this.repository, this.index);
        this.delegate.open();
    }

    @PreDestroy
    public void close() throws IOException {
        this.delegate.close();
    }

    public Optional<ICallModel> acquireModel(UniqueTypeName key) {
        return this.delegate.acquireModel((IUniqueName)key);
    }

    public void releaseModel(ICallModel value) {
        this.delegate.releaseModel((Object)value);
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryOpenedEvent e) throws IOException {
        this.open();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryClosedEvent e) throws IOException {
        this.close();
    }
}

