/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.InternalExtendedCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnLocalName;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedAllocationExpression;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.RecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.ProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.internal.completion.rcp.LogMessages;
import org.eclipse.recommenders.rcp.utils.ASTNodeUtils;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.rcp.utils.TimeDelimitedProgressMonitor;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionContextFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(CompletionContextFunctions.class);
    private static final char[] EMPTY = new char[0];

    public static Map<CompletionContextKey, ICompletionContextFunction> defaultFunctions() {
        HashMap<CompletionContextKey, ICompletionContextFunction> res = new HashMap<CompletionContextKey, ICompletionContextFunction>();
        res.put(CompletionContextKey.COMPLETION_PREFIX, new CompletionPrefixContextFunction());
        res.put(CompletionContextKey.IS_COMPLETION_ON_TYPE, new CompletionOnTypeContextFunction());
        res.put(CompletionContextKey.ENCLOSING_ELEMENT, new EnclosingElementContextFunction());
        res.put(CompletionContextKey.ENCLOSING_TYPE, new EnclosingTypeContextFunction());
        res.put(CompletionContextKey.ENCLOSING_METHOD, new EnclosingMethodContextFunction());
        res.put(CompletionContextKey.ENCLOSING_AST_METHOD, new EnclosingAstMethodContextFunction());
        res.put(CompletionContextKey.ENCLOSING_METHOD_FIRST_DECLARATION, new EnclosingMethodFirstDeclarationContextFunction());
        res.put(CompletionContextKey.EXPECTED_TYPE, new ExpectedTypeContextFunction());
        res.put(CompletionContextKey.EXPECTED_TYPENAMES, new ExpectedTypeNamesContextFunction());
        res.put(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, new InternalCompletionContextFunction());
        res.put(CompletionContextKey.JAVA_PROPOSALS, new InternalCompletionContextFunction());
        res.put(CompletionContextKey.JAVA_CONTENTASSIST_CONTEXT, new JavaContentAssistInvocationContextFunction());
        res.put(CompletionContextKey.LOOKUP_ENVIRONMENT, new LookupEnvironmentContextFunction());
        res.put(CompletionContextKey.RECEIVER_TYPEBINDING, new ReceiverTypeBindingContextFunction());
        res.put(CompletionContextKey.RECEIVER_NAME, new ReceiverNameContextFunction());
        res.put(CompletionContextKey.VISIBLE_METHODS, new VisibleMethodsContextFunction());
        res.put(CompletionContextKey.VISIBLE_FIELDS, new VisibleFieldsContextFunction());
        res.put(CompletionContextKey.VISIBLE_LOCALS, new VisibleLocalsContextFunction());
        res.put(CompletionContextKey.SESSION_ID, new SessionIdFunction());
        return res;
    }

    public static class CompletionOnTypeContextFunction
    implements ICompletionContextFunction<Boolean> {
        @Override
        public Boolean compute(IRecommendersCompletionContext context, CompletionContextKey<Boolean> key) {
            ASTNode node = (ASTNode)context.getCompletionNode().orNull();
            boolean res = false;
            if (node instanceof CompletionOnQualifiedNameReference) {
                Binding binding = ((CompletionOnQualifiedNameReference)node).binding;
                res = binding != null && 4 == binding.kind();
            }
            context.set(key, res);
            return res;
        }
    }

    public static class CompletionPrefixContextFunction
    implements ICompletionContextFunction<String> {
        @Override
        public String compute(IRecommendersCompletionContext context, CompletionContextKey<String> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            char[] prefix = EMPTY;
            if (ctx != null) {
                prefix = (char[])Objects.firstNonNull((Object)ctx.getToken(), (Object)EMPTY);
            }
            String res = new String(prefix);
            context.set(key, res);
            return res;
        }
    }

    public static class E37ContextInitializerCompletionContextFunction
    implements ICompletionContextFunction<Void> {
        private static Field fAssistScope;
        private static Field fAssistNode;
        private static Field fAssistNodeParent;
        private static Field fCompilationUnitDeclaration;
        private static Field fExtendedContext;

        static {
            try {
                Class<InternalCompletionContext> clazzCtx = InternalCompletionContext.class;
                fExtendedContext = clazzCtx.getDeclaredField("extendedContext");
                fExtendedContext.setAccessible(true);
                Class<InternalExtendedCompletionContext> clazzExt = InternalExtendedCompletionContext.class;
                fAssistScope = clazzExt.getDeclaredField("assistScope");
                fAssistScope.setAccessible(true);
                fAssistNode = clazzExt.getDeclaredField("assistNode");
                fAssistNode.setAccessible(true);
                fAssistNodeParent = clazzExt.getDeclaredField("assistNodeParent");
                fAssistNodeParent.setAccessible(true);
                fCompilationUnitDeclaration = clazzExt.getDeclaredField("compilationUnitDeclaration");
                fCompilationUnitDeclaration.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public Void compute(IRecommendersCompletionContext context, CompletionContextKey<Void> key) {
            InternalExtendedCompletionContext extContext;
            block3: {
                InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
                extContext = (InternalExtendedCompletionContext)Checks.cast((Object)fExtendedContext.get(ctx));
                if (extContext != null) break block3;
                return null;
            }
            try {
                ASTNode assistNode = (ASTNode)Checks.cast((Object)fAssistNode.get(extContext));
                context.set(CompletionContextKey.ASSIST_NODE, assistNode);
                ASTNode assistNodeParent = (ASTNode)Checks.cast((Object)fAssistNodeParent.get(extContext));
                context.set(CompletionContextKey.ASSIST_NODE_PARENT, assistNodeParent);
                Scope assistScope = (Scope)Checks.cast((Object)fAssistScope.get(extContext));
                context.set(CompletionContextKey.ASSIST_SCOPE, assistScope);
                CompilationUnitDeclaration cuDeclaration = (CompilationUnitDeclaration)Checks.cast((Object)fCompilationUnitDeclaration.get(extContext));
                context.set(CompletionContextKey.CCTX_COMPILATION_UNIT_DECLARATION, cuDeclaration);
            }
            catch (Exception e) {
                LOG.error("Reflection initalizer failed.", (Throwable)e);
            }
            return null;
        }
    }

    public static class EnclosingAstMethodContextFunction
    implements ICompletionContextFunction<MethodDeclaration> {
        @Override
        public MethodDeclaration compute(IRecommendersCompletionContext context, CompletionContextKey<MethodDeclaration> key) {
            MethodDeclaration astMethod = null;
            IMethod jdtMethod = (IMethod)context.getEnclosingMethod().orNull();
            if (jdtMethod != null) {
                CompilationUnit ast = context.getAST();
                astMethod = (MethodDeclaration)ASTNodeUtils.find((CompilationUnit)ast, (IMethod)jdtMethod).orNull();
            }
            context.set(key, astMethod);
            return astMethod;
        }
    }

    public static class EnclosingElementContextFunction
    implements ICompletionContextFunction<IJavaElement> {
        @Override
        public IJavaElement compute(IRecommendersCompletionContext context, CompletionContextKey<IJavaElement> key) {
            IJavaElement res = null;
            try {
                InternalCompletionContext core = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
                if (core != null && core.isExtended()) {
                    res = core.getEnclosingElement();
                }
            }
            catch (Exception exception) {}
            context.set(key, res);
            return res;
        }
    }

    public static class EnclosingMethodContextFunction
    implements ICompletionContextFunction<IMethod> {
        @Override
        public IMethod compute(IRecommendersCompletionContext context, CompletionContextKey<IMethod> key) {
            IJavaElement enclosing = context.get(CompletionContextKey.ENCLOSING_ELEMENT, null);
            IMethod res = (IMethod)(enclosing instanceof IMethod ? enclosing : null);
            context.set(key, res);
            return res;
        }
    }

    public static class EnclosingMethodFirstDeclarationContextFunction
    implements ICompletionContextFunction<IMethod> {
        @Override
        public IMethod compute(IRecommendersCompletionContext context, CompletionContextKey<IMethod> key) {
            IMethod root = null;
            IMethod enclosing = context.get(CompletionContextKey.ENCLOSING_METHOD, null);
            if (enclosing != null) {
                root = JdtUtils.findFirstDeclaration((IMethod)enclosing);
            }
            context.set(key, root);
            return root;
        }
    }

    public static class EnclosingTypeContextFunction
    implements ICompletionContextFunction<IType> {
        @Override
        public IType compute(IRecommendersCompletionContext context, CompletionContextKey<IType> key) {
            IJavaElement enclosing = context.get(CompletionContextKey.ENCLOSING_ELEMENT, null);
            IType res = null;
            if (enclosing instanceof IType) {
                res = (IType)enclosing;
            } else if (enclosing instanceof IField) {
                res = ((IField)enclosing).getDeclaringType();
            }
            context.set(key, res);
            return res;
        }
    }

    public static class ExpectedTypeContextFunction
    implements ICompletionContextFunction<IType> {
        @Override
        public IType compute(IRecommendersCompletionContext context, CompletionContextKey<IType> key) {
            JavaContentAssistInvocationContext ctx = context.get(CompletionContextKey.JAVA_CONTENTASSIST_CONTEXT, null);
            IType res = ctx == null ? null : ctx.getExpectedType();
            context.set(key, res);
            return res;
        }
    }

    public static class ExpectedTypeNamesContextFunction
    implements ICompletionContextFunction<Set<ITypeName>> {
        @Override
        public Set<ITypeName> compute(IRecommendersCompletionContext context, CompletionContextKey<Set<ITypeName>> key) {
            char[][] keys;
            ASTNode completion = (ASTNode)context.getCompletionNode().orNull();
            InternalCompletionContext core = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (this.isArgumentCompletion(completion) && context.getPrefix().isEmpty()) {
                ICompilationUnit cu = context.getCompilationUnit();
                int offset = context.getInvocationOffset();
                keys = this.simulateCompletionWithFakePrefix(cu, offset);
            } else {
                keys = core.getExpectedTypesSignatures();
            }
            Set<ITypeName> res = RecommendersCompletionContext.createTypeNamesFromSignatures(keys);
            context.set(key, res);
            return res;
        }

        private boolean isArgumentCompletion(ASTNode completion) {
            return completion instanceof MessageSend || completion instanceof CompletionOnQualifiedAllocationExpression;
        }

        private char[][] simulateCompletionWithFakePrefix(ICompilationUnit cu, int offset) {
            MutableObject res;
            block5: {
                res = new MutableObject(null);
                ICompilationUnit wc = null;
                String fakePrefix = "___x";
                try {
                    try {
                        wc = cu.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                        IBuffer buffer = wc.getBuffer();
                        String contents = buffer.getContents();
                        String newContents = String.valueOf(StringUtils.substring((String)contents, (int)0, (int)offset)) + fakePrefix + StringUtils.substring((String)contents, (int)offset, (int)contents.length());
                        buffer.setContents(newContents);
                        wc.codeComplete(offset + 1, new CompletionRequestor(true){

                            public boolean isExtendedContextRequired() {
                                return true;
                            }

                            public void acceptContext(CompletionContext context) {
                                res.setValue((Object)context.getExpectedTypesKeys());
                                super.acceptContext(context);
                            }

                            public void accept(CompletionProposal proposal) {
                            }
                        });
                    }
                    catch (JavaModelException x) {
                        Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)x);
                        this.discardWorkingCopy(wc);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.discardWorkingCopy(wc);
                    throw throwable;
                }
                this.discardWorkingCopy(wc);
            }
            return (char[][])res.getValue();
        }

        private void discardWorkingCopy(ICompilationUnit wc) {
            try {
                if (wc != null) {
                    wc.discardWorkingCopy();
                }
            }
            catch (JavaModelException x) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)x);
            }
        }
    }

    public static class InternalCompletionContextFunction
    implements ICompletionContextFunction<Object> {
        @Override
        public Object compute(IRecommendersCompletionContext context, CompletionContextKey<Object> key) {
            JavaContentAssistInvocationContext coreContext = context.getJavaContext();
            int offset = context.getInvocationOffset();
            if (offset == -1) {
                return null;
            }
            ICompilationUnit cu = context.getCompilationUnit();
            ProposalCollectingCompletionRequestor collector = new ProposalCollectingCompletionRequestor(coreContext);
            try {
                cu.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)new TimeDelimitedProgressMonitor(5000));
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
            }
            InternalCompletionContext internal = collector.getCoreContext();
            context.set(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, internal);
            Map<IJavaCompletionProposal, CompletionProposal> proposals = collector.getProposals();
            context.set(CompletionContextKey.JAVA_PROPOSALS, proposals);
            if (CompletionContextKey.INTERNAL_COMPLETIONCONTEXT.equals(key)) {
                return internal;
            }
            return proposals;
        }
    }

    public static class JavaContentAssistInvocationContextFunction
    implements ICompletionContextFunction<JavaContentAssistInvocationContext> {
        @Override
        public JavaContentAssistInvocationContext compute(IRecommendersCompletionContext context, CompletionContextKey<JavaContentAssistInvocationContext> key) {
            JavaContentAssistInvocationContext res = context.getJavaContext();
            context.set(key, res);
            return res;
        }
    }

    public static class LookupEnvironmentContextFunction
    implements ICompletionContextFunction<LookupEnvironment> {
        private static Field fExtendedContext;
        private static Field fLookupEnvironment;

        static {
            try {
                Class<InternalCompletionContext> clazzCtx = InternalCompletionContext.class;
                fExtendedContext = clazzCtx.getDeclaredField("extendedContext");
                fExtendedContext.setAccessible(true);
                Class<InternalExtendedCompletionContext> clazzExt = InternalExtendedCompletionContext.class;
                fLookupEnvironment = clazzExt.getDeclaredField("lookupEnvironment");
                fLookupEnvironment.setAccessible(true);
            }
            catch (Exception e) {
                LOG.error("Cannot access InternalExtendedCompletionContext.LookupEnvironment by reflection.", (Throwable)e);
            }
        }

        @Override
        public LookupEnvironment compute(IRecommendersCompletionContext context, CompletionContextKey<LookupEnvironment> key) {
            InternalExtendedCompletionContext extCtx;
            LookupEnvironment env;
            block3: {
                env = null;
                InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
                extCtx = (InternalExtendedCompletionContext)Checks.cast((Object)fExtendedContext.get(ctx));
                if (extCtx != null) break block3;
                return null;
            }
            try {
                env = (LookupEnvironment)Checks.cast((Object)fLookupEnvironment.get(extCtx));
            }
            catch (Exception e) {
                LOG.error("Cannot access LookupEnvironment by reflection.", (Throwable)e);
            }
            context.set(key, env);
            return env;
        }
    }

    public static class ReceiverNameContextFunction
    implements ICompletionContextFunction<String> {
        @Override
        public String compute(IRecommendersCompletionContext context, CompletionContextKey<String> key) {
            CompletionOnQualifiedNameReference c;
            ASTNode n = (ASTNode)context.getCompletionNode().orNull();
            if (n == null) {
                return "";
            }
            char[] name = null;
            if (n instanceof CompletionOnQualifiedNameReference) {
                c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
                switch (c.binding.kind()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        VariableBinding b = (VariableBinding)c.binding;
                        name = b.name;
                    }
                }
            } else if (n instanceof CompletionOnLocalName) {
                c = (CompletionOnLocalName)Checks.cast((Object)n);
                name = c.realName;
            } else if (n instanceof CompletionOnSingleNameReference) {
                name = new char[]{};
            } else if (n instanceof CompletionOnMemberAccess) {
                c = (CompletionOnMemberAccess)Checks.cast((Object)n);
                if (c.receiver instanceof ThisReference) {
                    name = "this".toCharArray();
                } else if (c.receiver instanceof MessageSend) {
                    name = null;
                } else if (c.fieldBinding() != null) {
                    name = c.fieldBinding().name;
                } else if (c.localVariableBinding() != null) {
                    name = c.localVariableBinding().name;
                }
            }
            String res = new String((char[])Objects.firstNonNull((Object)name, (Object)EMPTY));
            res = res.replace(" ", "");
            context.set(key, res);
            return res;
        }
    }

    public static class ReceiverTypeBindingContextFunction
    implements ICompletionContextFunction<TypeBinding> {
        @Override
        public TypeBinding compute(IRecommendersCompletionContext context, CompletionContextKey<TypeBinding> key) {
            ASTNode n = (ASTNode)context.getCompletionNode().orNull();
            if (n == null) {
                return null;
            }
            TypeBinding receiver = null;
            if (!(n instanceof CompletionOnLocalName)) {
                if (n instanceof CompletionOnSingleNameReference) {
                    CompletionOnSingleNameReference c = (CompletionOnSingleNameReference)Checks.cast((Object)n);
                    receiver = c.resolvedType;
                } else if (n instanceof CompletionOnQualifiedNameReference) {
                    CompletionOnQualifiedNameReference c = (CompletionOnQualifiedNameReference)Checks.cast((Object)n);
                    switch (c.binding.kind()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            VariableBinding varBinding = (VariableBinding)c.binding;
                            receiver = varBinding.type;
                            break;
                        }
                        case 4: 
                        case 2052: {
                            receiver = (TypeBinding)c.binding;
                        }
                    }
                } else if (n instanceof CompletionOnMemberAccess) {
                    CompletionOnMemberAccess c = (CompletionOnMemberAccess)Checks.cast((Object)n);
                    receiver = c.actualReceiverType;
                }
            }
            context.set(key, receiver);
            return receiver;
        }
    }

    public static class SessionIdFunction
    implements ICompletionContextFunction<UUID> {
        @Override
        public UUID compute(IRecommendersCompletionContext context, CompletionContextKey<UUID> key) {
            UUID res = UUID.randomUUID();
            context.set(key, res);
            return res;
        }
    }

    public static class VisibleFieldsContextFunction
    implements ICompletionContextFunction<List<IField>> {
        @Override
        public List<IField> compute(IRecommendersCompletionContext context, CompletionContextKey<List<IField>> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (ctx == null || !ctx.isExtended()) {
                return Collections.emptyList();
            }
            ObjectVector v = ctx.getVisibleFields();
            ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
            int i = v.size();
            while (i-- > 0) {
                FieldBinding b = (FieldBinding)Checks.cast((Object)v.elementAt(i));
                Optional f = JdtUtils.createUnresolvedField((FieldBinding)b);
                if (!f.isPresent()) continue;
                res.add((IField)f.get());
            }
            context.set(key, res);
            return res;
        }
    }

    public static class VisibleLocalsContextFunction
    implements ICompletionContextFunction<List<ILocalVariable>> {
        @Override
        public List<ILocalVariable> compute(IRecommendersCompletionContext context, CompletionContextKey<List<ILocalVariable>> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (ctx == null || !ctx.isExtended()) {
                return Collections.emptyList();
            }
            ObjectVector v = ctx.getVisibleLocalVariables();
            ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
            int i = v.size();
            while (i-- > 0) {
                LocalVariableBinding b = (LocalVariableBinding)Checks.cast((Object)v.elementAt(i));
                JavaElement parent = (JavaElement)context.getEnclosingElement().get();
                ILocalVariable f = JdtUtils.createUnresolvedLocaVariable((VariableBinding)b, (JavaElement)parent);
                res.add(f);
            }
            context.set(key, res);
            return res;
        }
    }

    public static class VisibleMethodsContextFunction
    implements ICompletionContextFunction<List<IMethod>> {
        @Override
        public List<IMethod> compute(IRecommendersCompletionContext context, CompletionContextKey<List<IMethod>> key) {
            InternalCompletionContext ctx = context.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
            if (ctx == null || !ctx.isExtended()) {
                return Collections.emptyList();
            }
            ObjectVector v = ctx.getVisibleMethods();
            ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
            int i = v.size();
            while (i-- > 0) {
                MethodBinding b = (MethodBinding)Checks.cast((Object)v.elementAt(i));
                Optional f = JdtUtils.createUnresolvedMethod((MethodBinding)b);
                if (!f.isPresent()) continue;
                res.add((IMethod)f.get());
            }
            context.set(key, res);
            return res;
        }
    }
}

