/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Checks;

public final class Dependencies {
    public static Optional<DependencyInfo> createDependencyInfoForJre(IJavaProject javaProject) {
        Optional<String> executionEnvironmentId = Dependencies.getExecutionEnvironmentId(javaProject);
        try {
            IVMInstall vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
            if (vmInstall == null) {
                return Optional.absent();
            }
            File javaHome = vmInstall.getInstallLocation();
            HashMap hints = Maps.newHashMap();
            if (executionEnvironmentId.isPresent()) {
                hints.put("EXECUTION_ENVIRONMENT", (String)executionEnvironmentId.get());
            }
            return Optional.of((Object)new DependencyInfo(javaHome, DependencyType.JRE, (Map)hints));
        }
        catch (CoreException coreException) {
            return Optional.absent();
        }
    }

    private static Optional<String> getExecutionEnvironmentId(IJavaProject javaProject) {
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5) {
                    return Optional.fromNullable((Object)JavaRuntime.getExecutionEnvironmentId((IPath)entry.getPath()));
                }
                ++n2;
            }
            return Optional.absent();
        }
        catch (JavaModelException javaModelException) {
            return Optional.absent();
        }
    }

    public static DependencyInfo createDependencyInfoForJar(IPackageFragmentRoot pfr) {
        File file = (File)Checks.ensureIsNotNull((Object)((File)JdtUtils.getLocation((IPackageFragmentRoot)pfr).orNull()), (String)"Could not determine absolute location of %s.", (Object[])new Object[]{pfr});
        return new DependencyInfo(file, DependencyType.JAR);
    }

    public static DependencyInfo createDependencyInfoForProject(IJavaProject project) {
        File file = project.getProject().getLocation().toFile();
        return new DependencyInfo(file, DependencyType.PROJECT, (Map)ImmutableMap.of((Object)"PROJECT_NAME", (Object)project.getElementName()));
    }
}

