/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.utils.Checks;

public class DependencyInfo {
    public static final String EXECUTION_ENVIRONMENT = "EXECUTION_ENVIRONMENT";
    public static final String EXECUTION_ENVIRONMENT_VERSION = "EXECUTION_ENVIRONMENT_VERSION";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    private final File file;
    private final DependencyType type;
    private final Map<String, String> hints;

    public DependencyInfo(File file, DependencyType type) {
        this(file, type, Collections.emptyMap());
    }

    public DependencyInfo(File file, DependencyType type, Map<String, String> hint) {
        this.file = (File)Checks.ensureIsNotNull((Object)file);
        Checks.ensureIsTrue((boolean)file.isAbsolute());
        this.type = type;
        this.hints = (Map)Checks.ensureIsNotNull(hint);
    }

    public File getFile() {
        return this.file;
    }

    public DependencyType getType() {
        return this.type;
    }

    public Optional<String> getHint(String key) {
        return Optional.fromNullable((Object)this.hints.get(key));
    }

    public ImmutableMap<String, String> getHints() {
        return ImmutableMap.copyOf(this.hints);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.file).addValue((Object)this.type).addValue(this.hints).toString();
    }
}

