/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.Versions;

public final class ModelCoordinate {
    public static final ModelCoordinate UNKNOWN = new ModelCoordinate("unknown", "unknown", "unknown", "unknown", "0.0.0");
    public static final String HINT_REPOSITORY_URL = "repository.url";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private Map<String, String> hints = Maps.newHashMap();

    public ModelCoordinate(String groupId, String artifactId, String classifier, String extension, String version) {
        Checks.ensureIsTrue((boolean)Coordinates.isValidId(artifactId));
        Checks.ensureIsTrue((boolean)Coordinates.isValidId(extension));
        Checks.ensureIsTrue((boolean)Versions.isValidVersion((String)version));
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.extension = extension;
        this.version = version;
    }

    public ModelCoordinate(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> hints) {
        this(groupId, artifactId, classifier, extension, version);
        this.hints = hints;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public Optional<String> getHint(String key) {
        return Optional.fromNullable((Object)this.hints.get(key));
    }

    public ImmutableMap<String, String> getHints() {
        return ImmutableMap.copyOf(this.hints);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return Joiner.on((char)':').useForNull("").join((Object)this.getGroupId(), (Object)this.getArtifactId(), new Object[]{this.getClassifier(), this.getExtension(), this.getVersion()});
    }

    public static ModelCoordinate valueOf(String coord) {
        String[] split = coord.split(":");
        String gid = null;
        String aid = null;
        String ext = null;
        String clss = null;
        String vers = null;
        switch (split.length) {
            case 1: 
            case 2: {
                throw Throws.throwIllegalArgumentException((String)"Invalid coordinate format. It has only %d segments: %s", (Object[])new Object[]{split.length, coord});
            }
            case 3: {
                vers = split[2];
                break;
            }
            case 4: {
                clss = split[2];
                vers = split[3];
                break;
            }
            case 5: {
                clss = split[2];
                ext = split[3];
                vers = split[4];
                break;
            }
            default: {
                Throws.throwIllegalArgumentException((String)"Invalid coordinate format. It has only %d segments: %s", (Object[])new Object[]{split.length, coord});
            }
        }
        gid = split[0];
        aid = split[1];
        return new ModelCoordinate(gid, aid, clss, ext, vers);
    }
}

