/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.models.advisors.OsgiManifestAdvisor;
import org.eclipse.recommenders.utils.Versions;

public class ModelIndexBundleSymbolicNameAdvisor
extends AbstractProjectCoordinateAdvisor {
    OsgiManifestAdvisor osgi;
    IModelIndex indexer;

    public ModelIndexBundleSymbolicNameAdvisor(IModelIndex indexer) {
        this(indexer, new OsgiManifestAdvisor());
    }

    @VisibleForTesting
    ModelIndexBundleSymbolicNameAdvisor(IModelIndex indexer, OsgiManifestAdvisor osgi) {
        this.indexer = indexer;
        this.osgi = osgi;
    }

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        ProjectCoordinate osgiPc = (ProjectCoordinate)this.osgi.doSuggest(dependencyInfo).orNull();
        if (osgiPc == null) {
            return Optional.absent();
        }
        String symbolicName = osgiPc.getArtifactId();
        ProjectCoordinate indexPc = (ProjectCoordinate)this.indexer.suggestProjectCoordinateByArtifactId(symbolicName).orNull();
        if (indexPc == null) {
            return Optional.absent();
        }
        return Coordinates.tryNewProjectCoordinate(indexPc.getGroupId(), indexPc.getArtifactId(), Versions.canonicalizeVersion((String)indexPc.getVersion()));
    }

    @Override
    protected boolean isApplicable(DependencyType dependencyType) {
        return this.osgi.isApplicable(dependencyType);
    }
}

