/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.base.Optional;
import java.util.StringTokenizer;

public final class OsgiVersionParser {
    public static Optional<String> parse(String version) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        try {
            StringTokenizer tokenizer = new StringTokenizer(version, ".", true);
            major = OsgiVersionParser.parseInt(tokenizer);
            if (tokenizer.hasMoreTokens()) {
                OsgiVersionParser.consumeDelimiter(tokenizer);
                minor = OsgiVersionParser.parseInt(tokenizer);
                if (tokenizer.hasMoreTokens()) {
                    OsgiVersionParser.consumeDelimiter(tokenizer);
                    micro = OsgiVersionParser.parseInt(tokenizer);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            return Optional.absent();
        }
        return Optional.of((Object)(String.valueOf(major) + "." + minor + "." + micro));
    }

    private static int parseInt(StringTokenizer st) {
        String token = st.nextToken();
        return Integer.parseInt(token);
    }

    private static void consumeDelimiter(StringTokenizer st) {
        st.nextToken();
    }

    private OsgiVersionParser() {
    }
}

