/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class Proxies {
    private static final String DOUBLEBACKSLASH = "\\\\";
    public static final String ENV_USERDOMAIN = "USERDOMAIN";
    public static final String PROP_HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";

    public static Optional<String> getUserDomain(String userName) {
        String domain = System.getProperty(PROP_HTTP_AUTH_NTLM_DOMAIN);
        if (domain != null) {
            return Optional.of((Object)domain);
        }
        domain = System.getenv(ENV_USERDOMAIN);
        if (domain != null) {
            return Optional.of((Object)domain);
        }
        if (StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH)) {
            return Optional.of((Object)StringUtils.substringBefore((String)userName, (String)DOUBLEBACKSLASH));
        }
        return Optional.absent();
    }

    public static Optional<String> getWorkstation() {
        try {
            return Optional.of((Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException unknownHostException) {
            return Optional.absent();
        }
    }

    public static Optional<String> getUserName(String userName) {
        if (userName == null) {
            return Optional.absent();
        }
        return StringUtils.contains((CharSequence)userName, (CharSequence)DOUBLEBACKSLASH) ? Optional.of((Object)StringUtils.substringAfterLast((String)userName, (String)DOUBLEBACKSLASH)) : Optional.of((Object)userName);
    }
}

