/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.internal.rcp.RcpPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDs {
    private static final Logger LOG = LoggerFactory.getLogger(UUIDs.class);

    public static String getUUID() {
        Optional<String> uuid = UUIDs.lookupUUIDFromStore();
        if (uuid.isPresent()) {
            return (String)uuid.get();
        }
        String newUuid = UUIDs.generateGlobalUUID();
        UUIDs.storeUUID(newUuid);
        return newUuid;
    }

    private static Optional<String> lookupUUIDFromStore() {
        RcpPlugin plugin = RcpPlugin.getDefault();
        IPreferenceStore prefStore = plugin.getPreferenceStore();
        String uuid = prefStore.getString("recommenders.uuid");
        if (Strings.isNullOrEmpty((String)uuid)) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)uuid);
    }

    private static void storeUUID(String uuid) {
        RcpPlugin plugin = RcpPlugin.getDefault();
        IPreferenceStore prefStore = plugin.getPreferenceStore();
        prefStore.putValue("recommenders.uuid", uuid);
    }

    public static String generateGlobalUUID() {
        Optional<String> uuid = UUIDs.generateUUIDFromMacAddress();
        if (!uuid.isPresent()) {
            return UUID.randomUUID().toString();
        }
        return (String)uuid.get();
    }

    private static Optional<String> generateUUIDFromMacAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            NetworkInterface[] networkInterfaceArray = (NetworkInterface[])Iterators.toArray((Iterator)Iterators.forEnumeration(e), NetworkInterface.class);
            int n = networkInterfaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                String uuid;
                NetworkInterface net = networkInterfaceArray[n2];
                byte[] mac = net.getHardwareAddress();
                if (!ArrayUtils.isEmpty((byte[])mac) && !Strings.isNullOrEmpty((String)(uuid = UUID.nameUUIDFromBytes(mac).toString()))) {
                    return Optional.fromNullable((Object)uuid);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to generate UUID from MAC address.", (Throwable)e);
        }
        return Optional.absent();
    }

    public static String newUuid() {
        return UUID.randomUUID().toString();
    }
}

