/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public class SnippetBuilder {
    private final CompilationUnit ast;
    private final IDocument doc;
    private final ITextSelection textSelection;
    private Set<String> imports;
    private HashMap<IVariableBinding, String> vars;
    private HashMap<String, Integer> lastVarIndex;
    private StringBuilder sb;

    public SnippetBuilder(CompilationUnit ast, IDocument doc, ITextSelection textSelection) {
        this.ast = ast;
        this.doc = doc;
        this.textSelection = textSelection;
    }

    /*
     * Unable to fully structure code
     */
    public String build() {
        start = this.textSelection.getOffset();
        length = this.textSelection.getLength();
        text = this.textSelection.getText().toCharArray();
        enclosingNode = NodeFinder.perform((ASTNode)this.ast, (int)start, (int)length);
        selection = Selection.createFromStartLength((int)start, (int)length);
        this.imports = Sets.newTreeSet();
        this.vars = Maps.newHashMap();
        this.lastVarIndex = Maps.newHashMap();
        this.sb = new StringBuilder();
        i = 0;
        while (i < text.length) {
            block18: {
                block17: {
                    ch = text[i];
                    if (Character.isJavaIdentifierPart(ch)) break block17;
                    this.sb.append(ch);
                    break block18;
                }
                nodeFinder = new NodeFinder(enclosingNode, start + i, 0);
                node = nodeFinder.getCoveringNode();
                if (!selection.covers(node)) ** GOTO lbl-1000
                block0 : switch (node.getNodeType()) {
                    case 42: {
                        name = (SimpleName)node;
                        b = name.resolveBinding();
                        if (b != null) {
                            switch (b.getKind()) {
                                case 2: {
                                    tb = (ITypeBinding)b;
                                    this.appendTypeBinding(name, tb);
                                    i += name.getLength() - 1;
                                    break block0;
                                }
                                case 3: {
                                    vb = (IVariableBinding)b;
                                    uniqueVariableName = this.generateUniqueVariableName(vb, name.toString());
                                    if (this.isDeclaration(name)) {
                                        this.appendNewName(uniqueVariableName, vb);
                                    } else if (this.declaredInSelection(selection, vb)) {
                                        this.appendTemplateVariableReference(uniqueVariableName);
                                    } else if (this.isQualified(name)) {
                                        this.sb.append(name.getIdentifier());
                                    } else if (vb.isField()) {
                                        this.appendVarReference(uniqueVariableName, vb, "field");
                                    } else {
                                        this.appendVarReference(uniqueVariableName, vb, "var");
                                    }
                                    i += name.getLength() - 1;
                                    break block0;
                                }
                            }
                        }
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        this.sb.append(ch);
                    }
                }
            }
            ++i;
        }
        this.sb.append("\n");
        this.appendImports();
        this.appendCursor();
        this.replaceLeadingWhitespaces();
        return this.sb.toString();
    }

    private boolean isDeclaration(SimpleName name) {
        StructuralPropertyDescriptor locationInParent = name.getLocationInParent();
        if (locationInParent == VariableDeclarationFragment.NAME_PROPERTY) {
            return true;
        }
        return locationInParent == SingleVariableDeclaration.NAME_PROPERTY;
    }

    private boolean declaredInSelection(Selection selection, IVariableBinding vb) {
        ASTNode declaringNode = this.ast.findDeclaringNode((IBinding)vb);
        if (declaringNode == null) {
            return false;
        }
        return selection.covers(declaringNode);
    }

    private boolean isQualified(SimpleName node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        return locationInParent == QualifiedName.NAME_PROPERTY;
    }

    private String generateUniqueVariableName(IVariableBinding vb, String name) {
        if (this.vars.containsKey(vb)) {
            return this.vars.get(vb);
        }
        String newName = name;
        Integer i = this.lastVarIndex.containsKey(newName) ? this.lastVarIndex.get(newName) : Integer.valueOf(1);
        while (this.vars.containsValue(newName)) {
            i = i + 1;
            newName = name.concat(i.toString());
        }
        this.lastVarIndex.put(name, i);
        this.vars.put(vb, newName);
        return newName;
    }

    private void appendTypeBinding(SimpleName name, ITypeBinding tb) {
        this.sb.append(name);
        this.addImport(tb);
    }

    private void appendNewName(String name, IVariableBinding vb) {
        ITypeBinding type = vb.getType();
        this.sb.append("${").append(name).append(":").append("newName").append("(");
        if (type.isArray()) {
            this.sb.append("'").append(type.getErasure().getQualifiedName()).append("'");
        } else {
            this.sb.append(type.getErasure().getQualifiedName());
        }
        this.sb.append(")").append("}");
        this.addImport(type);
    }

    private StringBuilder appendTemplateVariableReference(String name) {
        return this.sb.append("${").append(name).append("}");
    }

    private void appendVarReference(String name, IVariableBinding vb, String kind) {
        ITypeBinding type = vb.getType();
        this.sb.append("${").append(name).append(":").append(kind).append("(");
        if (type.isArray()) {
            this.sb.append("'").append(type.getErasure().getQualifiedName()).append("'");
        } else {
            this.sb.append(type.getErasure().getQualifiedName());
        }
        this.sb.append(")").append("}");
        this.addImport(type);
    }

    private void appendImports() {
        if (!this.imports.isEmpty()) {
            String joinedTypes = Joiner.on((String)", ").join(this.imports);
            this.sb.append("${:import(").append(joinedTypes).append(")}");
        }
    }

    private void appendCursor() {
        this.sb.append("${cursor}");
    }

    private void addImport(ITypeBinding type) {
        if (type.isArray()) {
            this.addImport(type.getComponentType());
            return;
        }
        if (type.isPrimitive()) {
            return;
        }
        if (type.getPackage().getName().equals("java.lang")) {
            return;
        }
        String name = type.getErasure().getQualifiedName();
        this.imports.add(name);
    }

    private void replaceLeadingWhitespaces() {
        try {
            int startLineIndex = this.textSelection.getStartLine();
            int startLineBeginOffset = this.doc.getLineOffset(startLineIndex);
            int startLineEndOffset = this.doc.getLineOffset(startLineIndex + 1) - 1;
            int lineLength = startLineEndOffset - startLineBeginOffset;
            String line = this.doc.get(startLineBeginOffset, lineLength);
            int index = 0;
            while (index < line.length()) {
                if (!Character.isWhitespace(line.charAt(index))) break;
                ++index;
            }
            String wsPrefix = line.substring(0, index);
            String[] code = this.sb.toString().split("\\r?\\n");
            this.sb.setLength(0);
            String[] stringArray = code;
            int n = code.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                String clean = StringUtils.removeStart((String)l, (String)wsPrefix);
                this.sb.append(clean).append(SystemUtils.LINE_SEPARATOR);
                ++n2;
            }
        }
        catch (BadLocationException e) {
            Logs.log((Logs.ILogMessage)LogMessages.SNIPPET_REPLACE_LEADING_WHITESPACE_FAILED, (Throwable)e);
        }
    }
}

