/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.utils.Checks;

public class Snippet
implements ISnippet {
    public static final String FORMAT_VERSION = "format-3";
    @SerializedName(value="uuid")
    private UUID uuid;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="extraSearchTerms")
    private List<String> extraSearchTerms = Lists.newArrayList();
    @SerializedName(value="tags")
    private List<String> tags = Lists.newArrayList();
    @SerializedName(value="code")
    private String code;

    public Snippet(UUID uuid, String name, String description, List<String> extraSearchTerms, List<String> tags, String code) {
        Checks.ensureIsNotNull((Object)uuid);
        Checks.ensureIsNotNull((Object)name);
        Checks.ensureIsNotNull((Object)description);
        Checks.ensureIsNotNull(extraSearchTerms);
        Checks.ensureIsNotNull(tags);
        Checks.ensureIsNotNull((Object)code);
        this.uuid = uuid;
        this.name = name;
        this.description = description;
        this.extraSearchTerms = extraSearchTerms;
        this.tags = tags;
        this.code = code;
    }

    protected Snippet() {
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getExtraSearchTerms() {
        return ImmutableList.copyOf(this.extraSearchTerms);
    }

    @Override
    public List<String> getTags() {
        return ImmutableList.copyOf(this.tags);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExtraSearchTerms(List<String> extraSearchTerms) {
        this.extraSearchTerms.clear();
        this.extraSearchTerms.addAll(extraSearchTerms);
    }

    public void setTags(List<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static Snippet copy(ISnippet snippet) {
        return new Snippet(snippet.getUuid(), snippet.getName(), snippet.getDescription(), Lists.newArrayList(snippet.getExtraSearchTerms()), Lists.newArrayList(snippet.getTags()), snippet.getCode());
    }
}

