/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.jdt.internal.ui.text.java.GetterSetterCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyPackageCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodDeclarationCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposalFactory;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableAnonymousTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableFilledArgumentNamesMethodProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableGetterSetterCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableJavaMethodCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyGenericTypeProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyJavaTypeCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableLazyPackageCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableMethodDeclarationCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableOverrideCompletionProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProcessableParameterGuessingProposal;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.rcp.utils.ReflectionUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessableProposalFactory
implements IProcessableProposalFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessableProposalFactory.class);
    private static Class<JavaMethodCompletionProposal> javaMethodCompletionProposalClass;
    private static Class<JavaFieldWithCastedReceiverCompletionProposal> javaFieldWithCastedReceiverCompletionProposalClass;
    private static Class<OverrideCompletionProposal> overrideCompletionProposalClass;
    private static Class<AnonymousTypeCompletionProposal> anonymousTypeCompletionProposalClass;
    private static Class<JavaCompletionProposal> javaCompletionProposalClass;
    private static Class<LazyGenericTypeProposal> lazyGenericTypeProposalClass;
    private static Class<LazyJavaTypeCompletionProposal> lazyJavaTypeCompletionProposalClass;
    private static Class<FilledArgumentNamesMethodProposal> filledArgumentNamesMethodProposalClass;
    private static Class<ParameterGuessingProposal> parameterGuessingProposalClass;
    private static Class<MethodDeclarationCompletionProposal> methodDeclarationCompletionProposalClass;
    private static Class<LazyPackageCompletionProposal> lazyPackageCompletionProposalClass;
    private static Class<GetterSetterCompletionProposal> getterSetterCompletionProposalClass;
    private static Method proposalInfoMethod;

    static {
        proposalInfoMethod = (Method)ReflectionUtils.getDeclaredMethod(AbstractJavaCompletionProposal.class, (String)"getProposalInfo", (Class[])new Class[0]).orNull();
        try {
            javaMethodCompletionProposalClass = JavaMethodCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            javaFieldWithCastedReceiverCompletionProposalClass = JavaFieldWithCastedReceiverCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            overrideCompletionProposalClass = OverrideCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            anonymousTypeCompletionProposalClass = AnonymousTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            javaCompletionProposalClass = JavaCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            lazyGenericTypeProposalClass = LazyGenericTypeProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            lazyJavaTypeCompletionProposalClass = LazyJavaTypeCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            filledArgumentNamesMethodProposalClass = FilledArgumentNamesMethodProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            parameterGuessingProposalClass = ParameterGuessingProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            methodDeclarationCompletionProposalClass = MethodDeclarationCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            methodDeclarationCompletionProposalClass = MethodDeclarationCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            lazyPackageCompletionProposalClass = LazyPackageCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
        try {
            getterSetterCompletionProposalClass = GetterSetterCompletionProposal.class;
        }
        catch (NoClassDefFoundError e) {
            LOG.warn("Error while loading completion proposal class", (Throwable)e);
        }
    }

    public static IJavaCompletionProposal create(CompletionProposal coreProposal, IJavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context, IProcessableProposalFactory factory) {
        Class<?> c = uiProposal.getClass();
        try {
            if (javaMethodCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavaMethodCompletionProposal(coreProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (javaFieldWithCastedReceiverCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavaFieldWithCastedReceiverCompletionProposal(coreProposal, (JavaFieldWithCastedReceiverCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (overrideCompletionProposalClass == c) {
                IProcessableProposal res = factory.newOverrideCompletionProposal(coreProposal, (OverrideCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (anonymousTypeCompletionProposalClass == c) {
                IProcessableProposal res = factory.newAnonymousTypeCompletionProposal(coreProposal, (AnonymousTypeCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (javaCompletionProposalClass == c) {
                IProcessableProposal res = factory.newJavaCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (lazyGenericTypeProposalClass == c) {
                IProcessableProposal res = factory.newLazyGenericTypeProposal(coreProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (lazyJavaTypeCompletionProposalClass == c) {
                IProcessableProposal res = factory.newLazyJavaTypeCompletionProposal(coreProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (filledArgumentNamesMethodProposalClass == c) {
                IProcessableProposal res = factory.newFilledArgumentNamesMethodProposal(coreProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (parameterGuessingProposalClass == c) {
                IProcessableProposal res = factory.newParameterGuessingProposal(coreProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (methodDeclarationCompletionProposalClass == c) {
                IProcessableProposal res = factory.newMethodDeclarationCompletionProposal(coreProposal, (MethodDeclarationCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (lazyPackageCompletionProposalClass == c) {
                IProcessableProposal res = factory.newLazyPackageCompletionProposal(coreProposal, (LazyPackageCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            if (getterSetterCompletionProposalClass == c) {
                IProcessableProposal res = factory.newGetterSetterCompletionProposal(coreProposal, (GetterSetterCompletionProposal)uiProposal, context);
                ProcessableProposalFactory.setProposalInfo(res, uiProposal);
                return res;
            }
            LOG.warn("Unknown JDT proposal type '{}' ('{}'). Returning original proposal instead.", c, (Object)uiProposal.getDisplayString());
            return uiProposal;
        }
        catch (Exception e) {
            LOG.warn("Wrapping JDT proposal '{}' ('{}') failed. Returning original proposal instead.", new Object[]{c, uiProposal.getDisplayString(), e});
            return uiProposal;
        }
    }

    private static void setProposalInfo(IProcessableProposal crProposal, IJavaCompletionProposal uiProposal) {
        if (Checks.isNull((Object[])new Object[]{proposalInfoMethod, crProposal, uiProposal})) {
            return;
        }
        try {
            ProposalInfo info = (ProposalInfo)proposalInfoMethod.invoke((Object)uiProposal, new Object[0]);
            crProposal.setProposalInfo(info);
        }
        catch (Exception exception) {
            LOG.warn("Failed to set proposal info to '{}'). Returning proposal without additional info.", (Object)crProposal);
        }
    }

    @Override
    public IProcessableProposal newLazyGenericTypeProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyGenericTypeProposal(coreProposal, context));
    }

    protected IProcessableProposal postConstruct(IProcessableProposal res) {
        res.setProposalProcessorManager(new ProposalProcessorManager(res));
        return res;
    }

    @Override
    public IProcessableProposal newFilledArgumentNamesMethodProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableFilledArgumentNamesMethodProposal(coreProposal, context));
    }

    @Override
    public IProcessableProposal newParameterGuessingProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        boolean fillBestGuess = this.shouldFillArgumentNames();
        return this.postConstruct(new ProcessableParameterGuessingProposal(coreProposal, context, fillBestGuess));
    }

    private boolean shouldFillArgumentNames() {
        try {
            boolean res = PreferenceConstants.getPreferenceStore().getBoolean("content_assist_guess_method_arguments");
            return res;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public IProcessableProposal newAnonymousTypeCompletionProposal(CompletionProposal coreProposal, AnonymousTypeCompletionProposal uiProposal, JavaContentAssistInvocationContext context) throws JavaModelException {
        return this.postConstruct(new ProcessableAnonymousTypeCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context));
    }

    @Override
    public IProcessableProposal newJavaFieldWithCastedReceiverCompletionProposal(CompletionProposal coreProposal, JavaFieldWithCastedReceiverCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            return this.postConstruct(new ProcessableJavaFieldWithCastedReceiverCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context));
        }
        catch (JavaModelException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newJavaCompletionProposal(CompletionProposal coreProposal, JavaCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            return this.postConstruct(new ProcessableJavaCompletionProposal(coreProposal, uiProposal, context));
        }
        catch (JavaModelException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newJavaMethodCompletionProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableJavaMethodCompletionProposal(coreProposal, context));
    }

    @Override
    public IProcessableProposal newLazyJavaTypeCompletionProposal(CompletionProposal coreProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyJavaTypeCompletionProposal(coreProposal, context));
    }

    @Override
    public IProcessableProposal newOverrideCompletionProposal(CompletionProposal coreProposal, OverrideCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableOverrideCompletionProposal(coreProposal, (JavaCompletionProposal)uiProposal, context));
    }

    @Override
    public IProcessableProposal newMethodDeclarationCompletionProposal(CompletionProposal coreProposal, MethodDeclarationCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            IJavaElement enclosingElement = context.getCoreContext().getEnclosingElement();
            IType type = null;
            if (enclosingElement instanceof IType) {
                type = (IType)enclosingElement;
            } else if (enclosingElement instanceof IField) {
                type = ((IField)enclosingElement).getDeclaringType();
            } else if (enclosingElement instanceof IMethod) {
                type = ((IMethod)enclosingElement).getDeclaringType();
            }
            if (type != null) {
                return this.postConstruct(ProcessableMethodDeclarationCompletionProposal.newProposal(coreProposal, type, uiProposal.getRelevance()));
            }
        }
        catch (CoreException e) {
            throw Throwables.propagate((Throwable)e);
        }
        throw Throws.throwIllegalArgumentException((String)"No type found");
    }

    @Override
    public IProcessableProposal newGetterSetterCompletionProposal(CompletionProposal coreProposal, GetterSetterCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        try {
            IField field = (IField)uiProposal.getJavaElement();
            return this.postConstruct(new ProcessableGetterSetterCompletionProposal(coreProposal, field, uiProposal.getDisplayString().startsWith("get"), uiProposal.getRelevance()));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public IProcessableProposal newLazyPackageCompletionProposal(CompletionProposal coreProposal, LazyPackageCompletionProposal uiProposal, JavaContentAssistInvocationContext context) {
        return this.postConstruct(new ProcessableLazyPackageCompletionProposal(coreProposal, context));
    }
}

