/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.recommenders.internal.rcp.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public final class ReflectionUtils {
    private ReflectionUtils() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static Optional<Field> getDeclaredField(Class<?> declaringClass, String name) {
        try {
            Field field = declaringClass.getDeclaredField(name);
            field.setAccessible(true);
            return Optional.of((Object)field);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, (Throwable)e, (Object[])new Object[]{name});
            return Optional.absent();
        }
    }

    public static Optional<Method> getDeclaredMethod(Class<?> declaringClass, String name, Class<?> ... parameterTypes) {
        try {
            Method method = declaringClass.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return Optional.of((Object)method);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, (Throwable)e, (Object[])new Object[]{name});
            return Optional.absent();
        }
    }
}

