/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetBuilder;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetEditor;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetEditorInput;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSnippetHandler
extends AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSnippetHandler.class);
    private Set<ISnippetRepository> repos;
    private ExecutionEvent event;

    @Inject
    public CreateSnippetHandler(Set<ISnippetRepository> repos) {
        this.repos = repos;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.event = event;
        CompilationUnitEditor editor = (CompilationUnitEditor)Checks.cast((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event));
        Snippet snippet = this.createSnippet(editor);
        this.openSnippetInEditor(snippet);
        return null;
    }

    @VisibleForTesting
    public Snippet createSnippet(CompilationUnitEditor editor) throws ExecutionException {
        ISourceViewer viewer = editor.getViewer();
        ITypeRoot root = (ITypeRoot)Checks.cast((Object)editor.getViewPartInput());
        CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)root, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        IDocument doc = viewer.getDocument();
        ITextSelection textSelection = (ITextSelection)Checks.cast((Object)viewer.getSelectionProvider().getSelection());
        String code = new SnippetBuilder(ast, doc, textSelection).build();
        ArrayList keywords = Lists.newArrayList();
        ArrayList tags = Lists.newArrayList();
        return new Snippet(UUID.randomUUID(), "<new snippet>", "<enter description>", (List)keywords, (List)tags, code);
    }

    private void openSnippetInEditor(Snippet snippet) {
        for (ISnippetRepository r : this.repos) {
            if (!r.isImportSupported()) continue;
            try {
                SnippetEditorInput input = new SnippetEditorInput((ISnippet)snippet, r);
                IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)this.event).getActivePage();
                SnippetEditor ed = (SnippetEditor)((Object)Checks.cast((Object)page.openEditor((IEditorInput)input, "org.eclipse.recommenders.snipmatch.rcp.editors.snippet")));
                ed.setDirty(true);
                return;
            }
            catch (PartInitException e) {
                LOG.error(Messages.ERROR_WHILE_OPENING_EDITOR, (Throwable)e);
            }
        }
        MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)this.event), (String)Messages.ERROR_NO_EDITABLE_REPO_FOUND, (String)Messages.ERROR_NO_EDITABLE_REPO_FOUND_HINT);
    }
}

