/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.FS;
import org.eclipse.recommenders.snipmatch.FileSnippetRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitSnippetRepository
extends FileSnippetRepository {
    private static Logger LOG = LoggerFactory.getLogger(GitSnippetRepository.class);
    private final File basedir;
    private final String fetchUrl;
    private final File gitFile;
    private final String pushUrl;
    private final String pushBranchPrefix;

    public GitSnippetRepository(File basedir, String fetchUrl, String pushUrl, String pushBranchPrefix) {
        super(basedir);
        this.basedir = basedir;
        this.fetchUrl = fetchUrl;
        this.pushUrl = pushUrl;
        this.pushBranchPrefix = pushBranchPrefix;
        this.gitFile = new File(String.valueOf(basedir.getAbsolutePath()) + "/.git");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        GitSnippetRepository gitSnippetRepository = this;
        synchronized (gitSnippetRepository) {
            boolean updatePossible = false;
            boolean gitFileExists = this.gitFile.exists();
            if (gitFileExists) {
                updatePossible = this.isUpdatePossible();
            }
            try {
                try {
                    if (!updatePossible) {
                        if (gitFileExists) {
                            FileUtils.deleteDirectory((File)this.gitFile);
                        }
                        this.initializeSnippetsRepo();
                    }
                    this.configureGit();
                    this.pullSnippets();
                }
                catch (InvalidRemoteException e) {
                    LOG.error("Invalid remote repository.", (Throwable)e);
                    throw this.createException(updatePossible, MessageFormat.format("Invalid remote repository \"{0}\". Check the repository's URL.", this.fetchUrl), e);
                }
                catch (TransportException e) {
                    LOG.error("Transport operation failed.", (Throwable)e);
                    throw this.createException(updatePossible, "Could not connect to remote repository. Your internet connection may be down.", e);
                }
                catch (GitAPIException e) {
                    LOG.error("Exception while update/clone repository.", (Throwable)e);
                    throw this.createException(updatePossible, "Exception while updating/cloning repository.", e);
                }
                catch (CoreException e) {
                    LOG.error("Exception while opening repository.", (Throwable)e);
                    throw this.createException(updatePossible, "Exception while opening repository.", e);
                }
            }
            finally {
                super.open();
            }
        }
    }

    private IOException createException(boolean gitFileExists, String message, Throwable e) {
        if (gitFileExists) {
            return new GitUpdateException(message, e);
        }
        return new IOException(message, e);
    }

    private boolean isUpdatePossible() throws IOException {
        if (RepositoryCache.FileKey.isGitRepository((File)this.gitFile, (FS)FS.DETECTED)) {
            Repository localRepo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.gitFile)).build();
            for (Ref ref : localRepo.getAllRefs().values()) {
                if (ref.getObjectId() == null) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeSnippetsRepo() throws GitAPIException, InvalidRemoteException, TransportException, IOException {
        InitCommand init = Git.init();
        init.setBare(false);
        init.setDirectory(this.basedir);
        init.call();
    }

    private void configureGit() throws IOException {
        Git git = Git.open((File)this.gitFile);
        StoredConfig config = git.getRepository().getConfig();
        config.setString("remote", "origin", "url", this.getRepositoryLocation());
        config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
        config.setString("remote", "origin", "pushUrl", this.pushUrl);
        String pushBranch = "HEAD:" + this.pushBranchPrefix + "/" + "format-3";
        config.setString("remote", "origin", "push", pushBranch);
        config.setBoolean("http", null, "sslVerify", false);
        config.setString("branch", "format-3", "remote", "origin");
        String branch = "refs/heads/format-3";
        config.setString("branch", "format-3", "merge", branch);
        config.save();
    }

    private void pullSnippets() throws IOException, InvalidRemoteException, TransportException, GitAPIException, CoreException {
        String remoteBranch = "origin/format-3";
        Repository localRepo = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.gitFile)).build();
        Git git = new Git(localRepo);
        git.fetch().call();
        CheckoutCommand checkout = git.checkout();
        checkout.setName("format-3");
        checkout.setStartPoint(remoteBranch);
        checkout.setCreateBranch(!this.branchExistsLocally(git, "refs/heads/format-3"));
        checkout.call();
        PullCommand pull = git.pull();
        pull.call();
    }

    private boolean branchExistsLocally(Git git, String remoteBranch) throws GitAPIException {
        List branches = git.branchList().call();
        Collection branchNames = Collections2.transform((Collection)branches, (Function)new Function<Ref, String>(){

            public String apply(Ref input) {
                return input.getName();
            }
        });
        return branchNames.contains(remoteBranch);
    }

    @Override
    public String getRepositoryLocation() {
        return this.fetchUrl;
    }

    public class GitUpdateException
    extends IOException {
        public GitUpdateException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

