/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.subwords.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnFieldType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMethodReturnType;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.CompletionContexts;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.RecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.ProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.internal.subwords.rcp.LCSS;
import org.eclipse.recommenders.internal.subwords.rcp.LogMessages;
import org.eclipse.recommenders.internal.subwords.rcp.SubwordsRcpPreferences;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.utils.TimeDelimitedProgressMonitor;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.ui.IEditorPart;

public class SubwordsSessionProcessor
extends SessionProcessor {
    private final IAstProvider astProvider;
    private final SubwordsRcpPreferences prefs;

    @Inject
    public SubwordsSessionProcessor(IAstProvider astProvider, SubwordsRcpPreferences prefs) {
        this.astProvider = astProvider;
        this.prefs = prefs;
    }

    public boolean startSession(IRecommendersCompletionContext crContext) {
        int length = crContext.getPrefix().length();
        if (length == 0) {
            return true;
        }
        TreeSet triggerlocations = Sets.newTreeSet();
        ASTNode completionNode = (ASTNode)crContext.getCompletionNode().orNull();
        ASTNode completionNodeParent = (ASTNode)crContext.getCompletionNodeParent().orNull();
        int offset = crContext.getInvocationOffset();
        if (completionNode instanceof CompletionOnSingleTypeReference && length > 1) {
            triggerlocations.add(offset - length + 1);
        }
        if (completionNode instanceof CompletionOnFieldType && length > 1) {
            triggerlocations.add(offset - length + 1);
        }
        if (completionNode instanceof CompletionOnMethodReturnType && length > 1) {
            triggerlocations.add(offset - length + 1);
        }
        if (completionNode instanceof CompletionOnSingleNameReference && completionNodeParent instanceof MessageSend && length > 1) {
            triggerlocations.add(offset - length + 1);
        }
        if (completionNode instanceof CompletionOnSingleNameReference && completionNodeParent == null && length > 1) {
            triggerlocations.add(offset - length + 1);
        }
        triggerlocations.add(offset - length);
        JavaContentAssistInvocationContext javaContext = crContext.getJavaContext();
        ICompilationUnit cu = crContext.getCompilationUnit();
        ITextViewer viewer = javaContext.getViewer();
        IEditorPart editor = this.lookupEditor(cu);
        Map baseProposals = crContext.getProposals();
        HashSet sortkeys = Sets.newHashSet();
        for (IJavaCompletionProposal p : baseProposals.keySet()) {
            sortkeys.add(p.getDisplayString());
        }
        Iterator<Object> iterator = triggerlocations.iterator();
        while (iterator.hasNext()) {
            int trigger = (Integer)iterator.next();
            Map<IJavaCompletionProposal, CompletionProposal> newProposals = this.getNewProposals(viewer, editor, trigger);
            for (IJavaCompletionProposal p : newProposals.keySet()) {
                String displayString = p.getDisplayString();
                String completion = CompletionContexts.getPrefixMatchingArea((String)displayString);
                if (sortkeys.contains(displayString) || !LCSS.containsSubsequence(completion, crContext.getPrefix())) continue;
                baseProposals.put(p, newProposals.get(p));
                sortkeys.add(p.getDisplayString());
            }
        }
        return true;
    }

    private Map<IJavaCompletionProposal, CompletionProposal> getNewProposals(ITextViewer viewer, IEditorPart editor, int trigger) {
        JavaContentAssistInvocationContext newJavaContext = new JavaContentAssistInvocationContext(viewer, trigger, editor);
        RecommendersCompletionContext newCrContext = new RecommendersCompletionContext(newJavaContext, this.astProvider);
        JavaContentAssistInvocationContext coreContext = newCrContext.getJavaContext();
        int offset = newCrContext.getInvocationOffset();
        if (offset == -1) {
            return Maps.newHashMap();
        }
        ICompilationUnit cu = newCrContext.getCompilationUnit();
        ProposalCollectingCompletionRequestor collector = new ProposalCollectingCompletionRequestor(coreContext, !this.prefs.computeAdditionalConstructorProposals, !this.prefs.computeAdditionalTypeProposals);
        try {
            cu.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)new TimeDelimitedProgressMonitor(5000));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
        }
        Map proposals = collector.getProposals();
        return proposals != null ? proposals : Maps.newHashMap();
    }

    @VisibleForTesting
    protected IEditorPart lookupEditor(ICompilationUnit cu) {
        return EditorUtility.isOpenInEditor((Object)cu);
    }

    public void process(final IProcessableProposal proposal) {
        proposal.getProposalProcessorManager().addProcessor(new ProposalProcessor(){
            int[] bestSequence = new int[0];
            String matchingArea;
            String prefix;
            {
                this.matchingArea = CompletionContexts.getPrefixMatchingArea((String)iProcessableProposal.getDisplayString());
            }

            public boolean isPrefix(String prefix) {
                this.prefix = prefix;
                this.bestSequence = LCSS.bestSubsequence(this.matchingArea, prefix);
                return prefix.isEmpty() || this.bestSequence.length > 0;
            }

            public void modifyDisplayString(StyledString displayString) {
                int[] nArray = this.bestSequence;
                int n = this.bestSequence.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    displayString.setStyle(index, 1, StyledString.COUNTER_STYLER);
                    ++n2;
                }
            }

            public int modifyRelevance() {
                if (ArrayUtils.isEmpty((int[])this.bestSequence)) {
                    proposal.setTag((IProposalTag)ProposalTag.SUBWORDS_SCORE, null);
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)true);
                    return 0;
                }
                if (StringUtils.startsWithIgnoreCase((CharSequence)this.matchingArea, (CharSequence)this.prefix)) {
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)true);
                    return 0x40000000;
                }
                int score = LCSS.scoreSubsequence(this.bestSequence);
                proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)false);
                proposal.setTag((IProposalTag)ProposalTag.SUBWORDS_SCORE, (Object)score);
                return score;
            }
        });
    }
}

