/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.completion.rcp.processable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.StopwatchSessionProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SessionProcessorDescriptor {
    private final IConfigurationElement config;
    private final String id;
    private final String name;
    private final String description;
    private final Image icon;
    private final int priority;
    private final boolean enabledByDefault;
    private final String preferencePage;
    private SessionProcessor processor;

    public SessionProcessorDescriptor(IConfigurationElement config) {
        this.config = config;
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.description = (String)Objects.firstNonNull((Object)config.getAttribute("description"), (Object)"");
        this.icon = SessionProcessorDescriptor.createIcon(config);
        String priorityString = config.getAttribute("priority");
        this.priority = priorityString == null ? 10 : Integer.parseInt(priorityString);
        String enabledByDefaultString = config.getAttribute("enabledByDefault");
        this.enabledByDefault = enabledByDefaultString == null ? true : Boolean.parseBoolean(enabledByDefaultString);
        this.preferencePage = config.getAttribute("preferencePage");
    }

    @VisibleForTesting
    public SessionProcessorDescriptor(String id, String name, String description, Image icon, int priority, boolean enabledByDefault, String preferencePage, SessionProcessor processor) {
        this.config = null;
        this.id = id;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.priority = priority;
        this.enabledByDefault = enabledByDefault;
        this.preferencePage = preferencePage;
        this.processor = processor;
    }

    private static Image createIcon(IConfigurationElement config) {
        String pluginId = config.getContributor().getName();
        String iconPath = config.getAttribute("icon");
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconPath).createImage();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }

    public synchronized SessionProcessor getProcessor() throws CoreException {
        if (this.processor == null) {
            this.processor = (SessionProcessor)this.config.createExecutableExtension("class");
            if (Boolean.getBoolean("org.eclipse.recommenders.completion.rcp.measure")) {
                this.processor = new StopwatchSessionProcessor(this.processor);
            }
        }
        return this.processor;
    }

    public Optional<String> getPreferencePage() {
        return Optional.fromNullable((Object)this.preferencePage);
    }

    public String toString() {
        return this.getId();
    }
}

