/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.ui.javaeditor.IndentUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.internal.snipmatch.rcp.LogMessages;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.swt.graphics.Image;

public class SnippetProposal
extends TemplateProposal
implements ICompletionProposalExtension6 {
    private final ISnippet snippet;
    private final boolean valid;

    public static SnippetProposal newSnippetProposal(Recommendation<ISnippet> recommendation, Template template, TemplateContext context, IRegion region, Image image) throws BadLocationException, TemplateException {
        boolean valid = false;
        try {
            context.evaluate(template);
            valid = true;
        }
        catch (Exception e) {
            context = new JavaContext(context.getContextType(), (IDocument)new Document(), new Position(0), null);
            context.evaluate(template);
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_SNIPPET_COULD_NOT_BE_EVALUATED, (Throwable)e);
        }
        int relevance = (int)(recommendation.getRelevance() * 100.0);
        return new SnippetProposal((ISnippet)recommendation.getProposal(), relevance, template, context, region, image, valid);
    }

    private SnippetProposal(ISnippet snippet, int relevance, Template template, TemplateContext context, IRegion region, Image image, boolean valid) {
        super(template, context, region, image, relevance);
        this.snippet = snippet;
        this.valid = valid;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.valid;
    }

    public String getAdditionalProposalInfo() {
        StringBuilder header = new StringBuilder();
        if (!this.valid) {
            header.append(MessageFormat.format(Messages.WARNING_CANNOT_APPLY_SNIPPET, "// XXX"));
            header.append(SystemUtils.LINE_SEPARATOR);
            header.append(MessageFormat.format(Messages.WARNING_REPOSITION_CURSOR, "// TODO"));
            header.append(SystemUtils.LINE_SEPARATOR);
            header.append(SystemUtils.LINE_SEPARATOR);
        }
        if (!StringUtils.isEmpty((CharSequence)this.snippet.getDescription())) {
            header.append("// ");
            header.append(this.snippet.getDescription());
            header.append(SystemUtils.LINE_SEPARATOR);
        }
        try {
            return header + this.fixIndentation(super.getAdditionalProposalInfo());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private String fixIndentation(String additionalProposalInfo) throws BadLocationException {
        Document document = new Document(additionalProposalInfo);
        IndentUtil.indentLines((IDocument)document, (ILineRange)new LineRange(0, document.getNumberOfLines()), null, null);
        return document.get();
    }

    public StyledString getStyledDisplayString() {
        StyledString styledString = new StyledString();
        styledString.append(SnippetProposal.createDisplayString(this.snippet));
        if (!this.snippet.getTags().isEmpty()) {
            styledString.append(" - ", StyledString.QUALIFIER_STYLER);
            styledString.append(Joiner.on((String)", ").join((Iterable)Ordering.natural().sortedCopy((Iterable)this.snippet.getTags())), StyledString.COUNTER_STYLER);
        }
        return styledString;
    }

    public String getDisplayString() {
        return this.getStyledDisplayString().getString();
    }

    public static String createDisplayString(ISnippet snippet) {
        if (Strings.isNullOrEmpty((String)snippet.getDescription())) {
            return snippet.getName();
        }
        return MessageFormat.format(Messages.SEARCH_DISPLAY_STRING, snippet.getName(), snippet.getDescription());
    }

    public ISnippet getSnippet() {
        return this.snippet;
    }
}

