/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.recommenders.internal.snipmatch.rcp.EclipseGitSnippetRepository;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnippetProposal;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.rcp.utils.ObjectToBooleanConverter;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditor;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetsView
extends ViewPart
implements IRcpService {
    private static Logger LOG = LoggerFactory.getLogger(SnippetsView.class);
    private final Set<ISnippetRepository> repos;
    private Text txtSearch;
    private List list;
    private ListViewer viewer;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnAdd;
    private Button btnReconnect;
    private DataBindingContext ctx;
    private IViewerObservableList selection;
    private Job reconnectJob;

    @Inject
    public SnippetsView(Set<ISnippetRepository> repos) {
        this.repos = repos;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.txtSearch = new Text(composite, 2944);
        this.txtSearch.setMessage(Messages.SEARCH_PLACEHOLDER_SEARCH_TEXT);
        this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSearch.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnippetsView.this.refreshInput();
            }
        });
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && SnippetsView.this.list.getItemCount() != 0) {
                    SnippetsView.this.list.setFocus();
                    SnippetsView.this.list.setSelection(0);
                }
            }
        });
        new Label(composite, 0);
        this.viewer = new ListViewer(composite);
        this.list = this.viewer.getList();
        this.list.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.btnAdd = new Button(composite, 0);
        this.btnAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAdd.setText(Messages.SNIPPETS_VIEW_BUTTON_ADD);
        this.btnAdd.setEnabled(this.isImportSupported());
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ISnippetRepository repo : SnippetsView.this.repos) {
                    if (!repo.isImportSupported()) continue;
                    SnippetsView.this.doAdd(repo);
                    break;
                }
            }
        });
        this.btnEdit = new Button(composite, 0);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEdit.setText(Messages.SNIPPETS_VIEW_BUTTON_EDIT);
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnippetsView.this.doOpen();
            }
        });
        this.btnRemove = new Button(composite, 0);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnRemove.setText(Messages.SNIPPETS_VIEW_BUTTON_REMOVE);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = 0;
                while (i < SnippetsView.this.selection.size()) {
                    Recommendation recommendation = (Recommendation)Checks.cast((Object)SnippetsView.this.selection.get(i));
                    try {
                        for (ISnippetRepository repo : SnippetsView.this.repos) {
                            repo.delete(((ISnippet)recommendation.getProposal()).getUuid());
                        }
                    }
                    catch (Exception e) {
                        Throwables.propagate((Throwable)e);
                    }
                    ++i;
                }
            }
        });
        this.btnReconnect = new Button(composite, 0);
        this.btnReconnect.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnReconnect.setText(Messages.SNIPPETS_VIEW_BUTTON_RECONNECT);
        this.btnReconnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SnippetsView.this.reconnect();
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Recommendation recommendation = (Recommendation)Checks.cast((Object)element);
                ISnippet snippet = (ISnippet)recommendation.getProposal();
                return SnippetProposal.createDisplayString(snippet);
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SnippetsView.this.doOpen();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.refreshInput();
        this.selection = ViewersObservables.observeMultiSelection((Viewer)this.viewer);
        this.initDataBindings();
    }

    private void reconnect() {
        this.reconnectJob = new Job(Messages.JOB_RECONNECTING_SNIPPET_REPOSITORY){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SnippetsView.this.btnReconnect.setEnabled(false);
                    }
                });
                for (ISnippetRepository repo : SnippetsView.this.repos) {
                    try {
                        repo.close();
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                for (ISnippetRepository repo : SnippetsView.this.repos) {
                    try {
                        repo.open();
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SnippetsView.this.btnReconnect.setEnabled(true);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.reconnectJob.schedule();
    }

    @Subscribe
    public void onEvent(EclipseGitSnippetRepository.SnippetRepositoryOpenedEvent e) throws IOException {
        this.refreshInput();
    }

    @Subscribe
    public void onEvent(EclipseGitSnippetRepository.SnippetRepositoryClosedEvent e) throws IOException {
        this.refreshInput();
    }

    private boolean isImportSupported() {
        for (ISnippetRepository repo : this.repos) {
            if (!repo.isImportSupported()) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void onEvent(EclipseGitSnippetRepository.SnippetRepositoryContentChangedEvent e) throws IOException {
        this.refreshInput();
    }

    private void refreshInput() {
        Job refreshJob = new Job(Messages.JOB_REFRESHING_SNIPPETS_VIEW){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SnippetsView.this.viewer.getControl().isDisposed()) {
                            HashSet snippets = Sets.newHashSet();
                            for (ISnippetRepository repo : SnippetsView.this.repos) {
                                snippets.addAll(repo.search(SnippetsView.this.txtSearch.getText()));
                            }
                            SnippetsView.this.viewer.setInput((Object)snippets);
                        }
                        if (!SnippetsView.this.btnAdd.isDisposed()) {
                            SnippetsView.this.btnAdd.setEnabled(SnippetsView.this.isImportSupported());
                        }
                        if (!SnippetsView.this.btnEdit.isDisposed()) {
                            SnippetsView.this.btnEdit.setEnabled(false);
                        }
                        if (!SnippetsView.this.btnRemove.isDisposed()) {
                            SnippetsView.this.btnRemove.setEnabled(false);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        refreshJob.schedule();
    }

    private void doAdd(ISnippetRepository repo) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            Snippet snippet = new Snippet(UUID.randomUUID(), "", "", Collections.emptyList(), Collections.emptyList(), "");
            SnippetEditorInput input = new SnippetEditorInput((ISnippet)snippet, repo);
            SnippetEditor editor = (SnippetEditor)((Object)Checks.cast((Object)page.openEditor((IEditorInput)input, "org.eclipse.recommenders.snipmatch.rcp.editors.snippet")));
            editor.markDirtyUponSnippetCreation();
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void doOpen() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int i = 0;
        while (i < this.selection.size()) {
            Recommendation recommendation = (Recommendation)Checks.cast((Object)this.selection.get(i));
            try {
                ISnippet snippet = (ISnippet)recommendation.getProposal();
                ISnippetRepository repository = this.findRepoForOriginalSnippet(snippet);
                SnippetEditorInput input = new SnippetEditorInput(snippet, repository);
                page.openEditor((IEditorInput)input, "org.eclipse.recommenders.snipmatch.rcp.editors.snippet");
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
            ++i;
        }
    }

    private ISnippetRepository findRepoForOriginalSnippet(ISnippet snippet) {
        for (ISnippetRepository repo : this.repos) {
            if (!repo.hasSnippet(snippet.getUuid())) continue;
            return repo;
        }
        return null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void initDataBindings() {
        this.ctx = new DataBindingContext();
        UpdateValueStrategy simpleStrategy = new UpdateValueStrategy();
        simpleStrategy.setConverter((IConverter)new ObjectToBooleanConverter());
        IViewerObservableValue selectionValue = ViewerProperties.singleSelection().observe((Viewer)this.viewer);
        ISWTObservableValue enabledBtnEditValue = WidgetProperties.enabled().observe((Widget)this.btnEdit);
        this.ctx.bindValue((IObservableValue)selectionValue, (IObservableValue)enabledBtnEditValue, simpleStrategy, null);
        UpdateValueStrategy deleteSupportedStrategy = new UpdateValueStrategy();
        deleteSupportedStrategy.setConverter(new IConverter(){

            public Object getFromType() {
                return Recommendation.class;
            }

            public Object getToType() {
                return Boolean.class;
            }

            public Boolean convert(Object fromObject) {
                if (fromObject == null) {
                    return false;
                }
                Recommendation selection = (Recommendation)fromObject;
                ISnippet snippet = (ISnippet)selection.getProposal();
                for (ISnippetRepository repo : SnippetsView.this.repos) {
                    if (!repo.isDeleteSupported() || !repo.hasSnippet(snippet.getUuid())) continue;
                    return true;
                }
                return false;
            }
        });
        ISWTObservableValue enabledBtnRemoveValue = WidgetProperties.enabled().observe((Widget)this.btnRemove);
        this.ctx.bindValue((IObservableValue)selectionValue, (IObservableValue)enabledBtnRemoveValue, deleteSupportedStrategy, null);
    }
}

