/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.editors;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetSourceValidator;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SnippetSourcePage
extends FormPage {
    private ISnippet snippet;
    private ScrolledForm form;
    private Text textWidget;
    private AbstractFormPart codePart;
    private DataBindingContext context;

    public SnippetSourcePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.form.setText(Messages.EDITOR_TITLE_RAW_SOURCE);
        toolkit.decorateFormHeading(this.form.getForm());
        Composite body = this.form.getBody();
        toolkit.paintBordersFor(body);
        body.setLayout((Layout)new FillLayout(256));
        this.codePart = new AbstractFormPart(){

            public void initialize(IManagedForm managedForm) {
                super.initialize(managedForm);
                SnippetSourcePage.this.textWidget = managedForm.getToolkit().createText(managedForm.getForm().getBody(), SnippetSourcePage.this.snippet.getCode(), 66);
            }

            public void refresh() {
                SnippetSourcePage.this.context.updateTargets();
                super.refresh();
                SnippetSourcePage.this.updateMessage();
            }

            public void commit(boolean onSave) {
                if (onSave) {
                    super.commit(onSave);
                }
            }

            public void dispose() {
                SnippetSourcePage.this.context.dispose();
                super.dispose();
            }
        };
        managedForm.addPart((IFormPart)this.codePart);
        this.context = this.createDataBindingContext();
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        this.registerEditorInputListener();
        super.init(site, input);
    }

    private void registerEditorInputListener() {
        this.getEditor().addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    SnippetSourcePage.this.setInputWithNotify(SnippetSourcePage.this.getEditor().getEditorInput());
                }
            }
        });
    }

    protected void setInputWithNotify(IEditorInput input) {
        this.snippet = ((SnippetEditorInput)input).getSnippet();
        this.context.dispose();
        this.context = this.createDataBindingContext();
        super.setInputWithNotify(input);
    }

    private void updateMessage() {
        String sourceValid = SnippetSourceValidator.isSourceValid(this.textWidget.getText());
        if (sourceValid.isEmpty()) {
            this.form.setMessage(null, 0);
        } else {
            this.form.setMessage(sourceValid, 3);
        }
    }

    private DataBindingContext createDataBindingContext() {
        DataBindingContext ctx = new DataBindingContext();
        IObservableValue snippetBeanCode = BeanProperties.value(Snippet.class, (String)"code", String.class).observe((Object)this.snippet);
        ISWTObservableValue textWidgetCode = WidgetProperties.text((int)24).observe((Widget)this.textWidget);
        ctx.bindValue((IObservableValue)textWidgetCode, snippetBeanCode);
        snippetBeanCode.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (!SnippetSourcePage.this.textWidget.getText().equals(SnippetSourcePage.this.snippet.getCode())) {
                    SnippetSourcePage.this.codePart.markStale();
                } else {
                    SnippetSourcePage.this.codePart.markDirty();
                }
                SnippetSourcePage.this.updateMessage();
            }
        });
        return ctx;
    }
}

