/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch.rcp;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.editors.SnippetSourceValidator;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.snipmatch.rcp.ISnippetEditorPageFactory;
import org.eclipse.recommenders.snipmatch.rcp.SnippetEditorInput;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetEditor
extends FormEditor
implements IResourceChangeListener {
    private static Logger LOG = LoggerFactory.getLogger(SnippetEditor.class);

    public SnippetEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        Checks.ensureIsInstanceOf((Object)editorInput, SnippetEditorInput.class);
        this.setPartName(editorInput.getName());
        super.init(site, editorInput);
    }

    protected void addPages() {
        try {
            for (IFormPage page : SnippetEditor.readExtensionPoint(this)) {
                this.addPage(page);
            }
        }
        catch (PartInitException e) {
            LOG.error("Exception while adding editor pages.", (Throwable)e);
        }
    }

    private static List<IFormPage> readExtensionPoint(SnippetEditor editor) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.recommenders.snipmatch.rcp.pageFactories");
        LinkedList pages = Lists.newLinkedList();
        for (IConfigurationElement element : Ordering.natural().onResultOf((Function)new Function<IConfigurationElement, Integer>(){

            public Integer apply(IConfigurationElement element) {
                String priorityString = element.getAttribute("priority");
                return priorityString == null ? 100 : Integer.valueOf(priorityString);
            }
        }).sortedCopy(Arrays.asList(elements))) {
            try {
                String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                ISnippetEditorPageFactory pageFactory = (ISnippetEditorPageFactory)element.createExecutableExtension("class");
                IFormPage page = pageFactory.createPage(editor, id, name);
                pages.add(page);
            }
            catch (CoreException coreException) {}
        }
        return pages;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        SnippetEditorInput input = (SnippetEditorInput)this.getEditorInput();
        Snippet snippet = input.getSnippet();
        ISnippetRepository repo = input.getRepository();
        if (repo == null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DIALOG_TITLE_ERROR_WHILE_STORING_SNIPPET, (String)Messages.DIALOG_MESSAGE_NO_REPOSITORY_AVAILABLE);
            monitor.setCanceled(true);
            return;
        }
        if (Strings.isNullOrEmpty((String)snippet.getName())) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DIALOG_TITLE_INAVLID_SNIPPET_NAME, (String)Messages.DIALOG_MESSAGE_INVALID_SNIPPET_NAME);
            monitor.setCanceled(true);
            return;
        }
        String sourceValid = SnippetSourceValidator.isSourceValid(snippet.getCode());
        if (!sourceValid.isEmpty()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.DIALOG_TITLE_ERROR_SNIPPET_SOURCE_INVALID, (String)MessageFormat.format(Messages.DIALOG_MESSAGE_ERROR_SNIPPET_SOURCE_INVALID, sourceValid));
            monitor.setCanceled(true);
            return;
        }
        ISnippet oldSnippet = input.getOldSnippet();
        if (!oldSnippet.getCode().isEmpty() && !snippet.getCode().equals(oldSnippet.getCode())) {
            int status = new MessageDialog(this.getSite().getShell(), Messages.DIALOG_TITLE_SAVE_SNIPPET, null, Messages.DIALOG_MESSAGE_SAVE_SNIPPET_WITH_MODIFIED_CODE, 3, new String[]{Messages.DIALOG_OPTION_SAVE, Messages.DIALOG_OPTION_SAVE_AS_NEW, Messages.DIALOG_OPTION_CANCEL}, 0).open();
            if (status == 1) {
                snippet.setUUID(UUID.randomUUID());
                this.setInputWithNotify(new SnippetEditorInput((ISnippet)snippet, input.getRepository()));
            }
            if (status == 2) {
                monitor.setCanceled(true);
                return;
            }
            if (status == -1) {
                monitor.setCanceled(true);
                return;
            }
        }
        try {
            this.commitPages(true);
            input.setOldSnippet(Snippet.copy((ISnippet)snippet));
            repo.importSnippet((ISnippet)snippet);
            this.setPartName(this.getEditorInput().getName());
            this.editorDirtyStateChanged();
        }
        catch (IOException e) {
            LOG.error("Exception while storing snippet.", (Throwable)e);
        }
    }

    public void doSaveAs() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
    }

    public void markDirtyUponSnippetCreation() {
        for (Object page : this.pages) {
            if (!(page instanceof IFormPage) || ((IFormPage)page).getManagedForm() == null) continue;
            IFormPart[] iFormPartArray = ((IFormPage)page).getManagedForm().getParts();
            int n = iFormPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                if (part instanceof AbstractFormPart) {
                    ((AbstractFormPart)part).markDirty();
                }
                ++n2;
            }
        }
    }
}

