/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.recommenders.internal.models.rcp.EclipseDependencyListener;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelIndex;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.internal.models.rcp.EclipseProjectCoordinateAdvisorService;
import org.eclipse.recommenders.internal.models.rcp.ManualProjectCoordinateAdvisor;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.ProjectCoordinateProvider;
import org.eclipse.recommenders.models.IDependencyListener;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IProjectCoordinateAdvisorService;
import org.eclipse.recommenders.models.advisors.ModelIndexBundleSymbolicNameAdvisor;
import org.eclipse.recommenders.models.advisors.ModelIndexFingerprintAdvisor;
import org.eclipse.recommenders.models.advisors.SharedManualMappingsAdvisor;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelsRcpModule
extends AbstractModule {
    private static final String EXT_ID_MODEL_CLASSIFIER = "org.eclipse.recommenders.models.rcp.models";
    private static final String MODEL_CLASSIFIER_ATTRIBUTE = "classifier";
    public static final String IDENTIFIED_PROJECT_COORDINATES = "IDENTIFIED_PACKAGE_FRAGMENT_ROOTS";
    public static final String MODEL_CLASSIFIER = "MODEL_CLASSIFIER";
    public static final String REPOSITORY_BASEDIR = "REPOSITORY_BASEDIR";
    public static final String INDEX_BASEDIR = "INDEX_BASEDIR";
    public static final String MANUAL_MAPPINGS = "MANUAL_MAPPINGS";
    private static final Logger LOG = LoggerFactory.getLogger(ModelsRcpModule.class);

    protected void configure() {
        this.bind(IProjectCoordinateProvider.class).to(ProjectCoordinateProvider.class).in(Scopes.SINGLETON);
        this.bind(EclipseProjectCoordinateAdvisorService.class).in(Scopes.SINGLETON);
        this.bind(IProjectCoordinateAdvisorService.class).to(EclipseProjectCoordinateAdvisorService.class);
        this.bind(EclipseModelIndex.class).in(Scopes.SINGLETON);
        this.bind(IModelArchiveCoordinateAdvisor.class).to(EclipseModelIndex.class);
        this.bind(IModelIndex.class).to(EclipseModelIndex.class);
        this.createAndBindNamedFile("index", INDEX_BASEDIR);
        this.bind(EclipseModelRepository.class).in(Scopes.SINGLETON);
        this.bind(IModelRepository.class).to(EclipseModelRepository.class);
        this.createAndBindNamedFile("repository", REPOSITORY_BASEDIR);
        this.bind(ManualProjectCoordinateAdvisor.class).in(Scopes.SINGLETON);
        this.createAndBindNamedFile("caches/manual-mappings.json", MANUAL_MAPPINGS);
        this.createAndBindNamedFile("caches/identified-project-coordinates.json", IDENTIFIED_PROJECT_COORDINATES);
    }

    private void createAndBindNamedFile(String fileName, String name) {
        File rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File stateLocation = new File(rootLocation, ".recommenders");
        File file = new File(stateLocation, fileName);
        try {
            Files.createParentDirs((File)file);
        }
        catch (IOException e) {
            LOG.error("Failed to bind file name {}.", (Object)fileName, (Object)e);
        }
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)name)).toInstance((Object)file);
    }

    @Singleton
    @Provides
    public IDependencyListener provideDependencyListener(EventBus bus) {
        return new EclipseDependencyListener(bus);
    }

    @Provides
    public IProxyService provideProxyService() {
        return ProxyManager.getProxyManager();
    }

    @Provides
    public ModelIndexBundleSymbolicNameAdvisor provideModelIndexBundleSymbolicNameAdvisor(IModelIndex index) {
        return new ModelIndexBundleSymbolicNameAdvisor(index);
    }

    @Provides
    public ModelIndexFingerprintAdvisor provideModelIndexFingerprintAdvisor(IModelIndex index) {
        return new ModelIndexFingerprintAdvisor(index);
    }

    @Provides
    public SharedManualMappingsAdvisor provideWorkspaceMappingsAdvisor(IModelRepository repository) {
        return new SharedManualMappingsAdvisor(repository);
    }

    @Provides
    @Singleton
    public ModelsRcpPreferences provide(IWorkbench wb, EventBus bus) {
        IEclipseContext context = (IEclipseContext)wb.getService(IEclipseContext.class);
        context.set(EventBus.class, (Object)bus);
        return (ModelsRcpPreferences)ContextInjectionFactory.make(ModelsRcpPreferences.class, (IEclipseContext)context);
    }

    @Provides
    @Named(value="MODEL_CLASSIFIER")
    public ImmutableSet<String> provideModelClassifiers() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID_MODEL_CLASSIFIER);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String classifier = element.getAttribute(MODEL_CLASSIFIER_ATTRIBUTE);
            builder.add((Object)classifier);
            ++n2;
        }
        return builder.build();
    }
}

