/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.recommenders.internal.snipmatch.rcp.BranchCheckoutFailureDialog;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchRcpPreferences;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.snipmatch.GitSnippetRepository;
import org.eclipse.recommenders.snipmatch.ISearchContext;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseGitSnippetRepository
implements ISnippetRepository,
IRcpService {
    private static Logger LOG = LoggerFactory.getLogger(EclipseGitSnippetRepository.class);
    private final EventBus bus;
    private final SnipmatchRcpPreferences prefs;
    private final File basedir;
    private volatile int timesOpened;
    private ISnippetRepository delegate;
    private volatile boolean delegateOpen;
    private final Lock readLock;
    private final Lock writeLock;
    private volatile Job openJob = null;

    @Inject
    public EclipseGitSnippetRepository(@Named(value="SNIPPET_REPOSITORY_BASEDIR") File basedir, SnipmatchRcpPreferences prefs, EventBus bus) {
        this.bus = bus;
        this.prefs = prefs;
        this.basedir = basedir;
        this.setupDelegate();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    private void setupDelegate() {
        String remoteUri = this.prefs.getFetchUrl();
        this.delegate = new GitSnippetRepository(new File(this.basedir, Urls.mangle((String)remoteUri)), remoteUri, this.prefs.getPushUrl(), this.prefs.getPushBranch());
    }

    @PostConstruct
    public void open() {
        this.writeLock.lock();
        try {
            ++this.timesOpened;
            if (this.timesOpened > 1) {
                return;
            }
            if (this.openJob == null && !this.delegateOpen) {
                this.openJob = new Job(Messages.JOB_OPENING_SNIPPET_REPOSITORY){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            EclipseGitSnippetRepository.this.delegate.open();
                            this.changeStateToOpen();
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (GitSnippetRepository.GitUpdateException e) {
                            this.changeStateToOpen();
                            Status status = new Status(2, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.WARNING_FAILURE_TO_UPDATE_REPOSITORY, EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (GitSnippetRepository.GitNoCurrentFormatBranchException e) {
                            this.changeStateToOpen();
                            Status status = new Status(2, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.WARNING_FAILURE_TO_CHECKOUT_CURRENT_BRANCH, "format-4", EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), e.getCheckoutVersion(), e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            final Display display = Display.getDefault();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BranchCheckoutFailureDialog dialog = new BranchCheckoutFailureDialog(display.getActiveShell(), EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), "format-4", e.getCheckoutVersion());
                                    dialog.open();
                                }
                            });
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        catch (GitSnippetRepository.GitNoFormatBranchException e) {
                            LOG.error("Exception while opening repository.", (Throwable)e);
                            Status status = new Status(4, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.ERROR_NO_FORMAT_BRANCH, "format-4", EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            final Display display = Display.getDefault();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BranchCheckoutFailureDialog dialog = new BranchCheckoutFailureDialog(display.getActiveShell(), EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), "format-4");
                                    dialog.open();
                                }
                            });
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        catch (IOException e) {
                            LOG.error("Exception while opening repository.", (Throwable)e);
                            Status status = new Status(4, "org.eclipse.recommenders.snipmatch.rcp", MessageFormat.format(Messages.ERROR_FAILURE_TO_CLONE_REPOSITORY, EclipseGitSnippetRepository.this.delegate.getRepositoryLocation(), EclipseGitSnippetRepository.this.timesOpened, e.getMessage()), (Throwable)e);
                            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.recommenders.snipmatch.rcp")).log((IStatus)status);
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        finally {
                            EclipseGitSnippetRepository.this.openJob = null;
                        }
                    }

                    private void changeStateToOpen() {
                        EclipseGitSnippetRepository.this.delegateOpen = true;
                        EclipseGitSnippetRepository.this.bus.post((Object)new SnippetRepositoryOpenedEvent(EclipseGitSnippetRepository.this));
                    }
                };
                this.openJob.schedule();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @PreDestroy
    public void close() throws IOException {
        block10: {
            this.writeLock.lock();
            try {
                if (this.timesOpened == 0) {
                    return;
                }
                if (this.timesOpened > 1) {
                    --this.timesOpened;
                    return;
                }
                if (this.timesOpened != 1) break block10;
                this.timesOpened = 0;
                if (this.openJob != null) {
                    try {
                        this.openJob.join();
                        this.openJob = null;
                    }
                    catch (InterruptedException e) {
                        LOG.error("Failed to join open job", (Throwable)e);
                    }
                }
                this.delegate.close();
                this.delegateOpen = false;
                this.bus.post((Object)new SnippetRepositoryClosedEvent(this));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public List<Recommendation<ISnippet>> search(ISearchContext context) {
        this.readLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                List<Recommendation<ISnippet>> list = Collections.emptyList();
                return list;
            }
            List list = this.delegate.search(context);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Recommendation<ISnippet>> search(ISearchContext context, int maxResults) {
        this.readLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                List<Recommendation<ISnippet>> list = Collections.emptyList();
                return list;
            }
            List list = this.delegate.search(context, maxResults);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Subscribe
    public void onEvent(SnippetRepositoryConfigurationChangedEvent e) throws IOException {
        this.close();
        this.setupDelegate();
        this.open();
    }

    public String getRepositoryLocation() {
        this.readLock.lock();
        try {
            Preconditions.checkState((boolean)this.isOpen());
            if (!this.delegateOpen) {
                return "";
            }
            String string = this.delegate.getRepositoryLocation();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasSnippet(UUID uuid) {
        this.readLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                return false;
            }
            boolean bl = this.delegate.hasSnippet(uuid);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean delete(UUID uuid) throws IOException {
        this.readLock.lock();
        try {
            if (!this.isOpen() || !this.delegateOpen) {
                return false;
            }
            boolean deleted = this.delegate.delete(uuid);
            if (deleted) {
                this.bus.post((Object)new SnippetRepositoryContentChangedEvent(this));
            }
            boolean bl = deleted;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isDeleteSupported() {
        return this.delegate.isDeleteSupported();
    }

    private boolean isOpen() {
        return this.timesOpened > 0;
    }

    public void importSnippet(ISnippet snippet) throws IOException {
        this.writeLock.lock();
        try {
            Preconditions.checkState((boolean)this.isOpen(), (Object)Messages.ERROR_REPOSITORY_NOT_OPEN_YET);
            this.delegate.importSnippet(snippet);
            this.bus.post((Object)new SnippetRepositoryContentChangedEvent(this));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isImportSupported() {
        return this.delegate.isImportSupported();
    }

    public static class SnippetRepositoryClosedEvent {
        private final ISnippetRepository repo;

        public SnippetRepositoryClosedEvent(ISnippetRepository repo) {
            this.repo = repo;
        }

        public ISnippetRepository getRepository() {
            return this.repo;
        }
    }

    public static class SnippetRepositoryConfigurationChangedEvent {
    }

    public static class SnippetRepositoryContentChangedEvent {
        private final ISnippetRepository repo;

        public SnippetRepositoryContentChangedEvent(ISnippetRepository repo) {
            this.repo = repo;
        }

        public ISnippetRepository getRepository() {
            return this.repo;
        }
    }

    public static class SnippetRepositoryOpenedEvent {
        private final ISnippetRepository repo;

        public SnippetRepositoryOpenedEvent(ISnippetRepository repo) {
            this.repo = repo;
        }

        public ISnippetRepository getRepository() {
            return this.repo;
        }
    }
}

