/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.eventbus.EventBus;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.recommenders.injection.InjectionService;
import org.eclipse.recommenders.internal.snipmatch.rcp.BranchInputValidator;
import org.eclipse.recommenders.internal.snipmatch.rcp.EclipseGitSnippetRepository;
import org.eclipse.recommenders.internal.snipmatch.rcp.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SnipmatchPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private EventBus bus = (EventBus)InjectionService.getInstance().requestInstance(EventBus.class);
    private final UriInputValidator uriValidator = new UriInputValidator();
    private final BranchInputValidator branchValidator = new BranchInputValidator();
    private final FieldDecoration errorDecoration;
    private StringFieldEditor snippetsRepoFetchUrlField;
    private StringFieldEditor snippetsRepoPushUrlField;
    private StringFieldEditor snippetsRepoPushBranchField;
    private ControlDecoration snippetsRepoFetchUrlDecoration;
    private ControlDecoration snippetsRepoPushUrlDecoration;
    private ControlDecoration snippetsRepoPushBranchDecoration;

    public SnipmatchPreferencePage() {
        super(1);
        this.setDescription(Messages.PREFPAGE_DESCRIPTION);
        this.errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.snipmatch.rcp");
        this.setPreferenceStore((IPreferenceStore)store);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(parent);
        this.addFetchGroup(parent);
        this.addPushGroup(parent);
    }

    private void addFetchGroup(Composite parent) {
        Group fetchGroup = new Group(parent, 16);
        fetchGroup.setText(Messages.GROUP_FETCH_SETTINGS);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)fetchGroup);
        this.snippetsRepoFetchUrlField = new StringFieldEditor("snippets.repo.url", Messages.PREFPAGE_LABEL_SNIPPETS_REPO_FETCH_URL, (Composite)fetchGroup){

            protected boolean doCheckState() {
                String errorMessage = SnipmatchPreferencePage.this.uriValidator.isValid(this.getStringValue());
                SnipmatchPreferencePage.this.snippetsRepoFetchUrlDecoration.setDescriptionText(errorMessage);
                if (errorMessage == null) {
                    SnipmatchPreferencePage.this.snippetsRepoFetchUrlDecoration.hide();
                } else {
                    SnipmatchPreferencePage.this.snippetsRepoFetchUrlDecoration.show();
                }
                return errorMessage == null;
            }

            protected void adjustForNumColumns(int numColumns) {
                ((GridData)this.getTextControl().getLayoutData()).horizontalSpan = numColumns - 2;
            }
        };
        this.snippetsRepoFetchUrlDecoration = new ControlDecoration((Control)this.snippetsRepoFetchUrlField.getTextControl((Composite)fetchGroup), 16512);
        this.snippetsRepoFetchUrlDecoration.setImage(this.errorDecoration.getImage());
        this.updateMargins(fetchGroup);
        this.addField((FieldEditor)this.snippetsRepoFetchUrlField);
    }

    private void addPushGroup(Composite parent) {
        Group pushGroup = new Group(parent, 16);
        pushGroup.setText(Messages.GROUP_PUSH_SETTINGS);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)pushGroup);
        this.snippetsRepoPushUrlField = new StringFieldEditor("snippets.repo.push.url", Messages.PREFPAGE_LABEL_SNIPPETS_REPO_PUSH_URL, (Composite)pushGroup){

            protected boolean doCheckState() {
                String errorMessage = SnipmatchPreferencePage.this.uriValidator.isValid(this.getStringValue());
                SnipmatchPreferencePage.this.snippetsRepoPushUrlDecoration.setDescriptionText(errorMessage);
                if (errorMessage == null) {
                    SnipmatchPreferencePage.this.snippetsRepoPushUrlDecoration.hide();
                } else {
                    SnipmatchPreferencePage.this.snippetsRepoPushUrlDecoration.show();
                }
                return errorMessage == null;
            }
        };
        this.snippetsRepoPushUrlDecoration = new ControlDecoration((Control)this.snippetsRepoPushUrlField.getTextControl((Composite)pushGroup), 16512);
        this.snippetsRepoPushUrlDecoration.setImage(this.errorDecoration.getImage());
        this.addField((FieldEditor)this.snippetsRepoPushUrlField);
        Label pushBranchDescription = new Label((Composite)pushGroup, 64);
        pushBranchDescription.setText(MessageFormat.format(Messages.PREFPAGE_LABEL_SNIPPETS_PUSH_SETTINGS_DESCRIPTION, "format-4"));
        GridDataFactory.fillDefaults().span(3, 1).hint(300, -1).grab(true, false).align(4, 1).applyTo((Control)pushBranchDescription);
        this.snippetsRepoPushBranchField = new StringFieldEditorWithPrefix("snippets.repo.push.branch", Messages.PREFPAGE_LABEL_SNIPPETS_REPO_PUSH_BRANCH, (Composite)pushGroup);
        this.snippetsRepoPushBranchDecoration = new ControlDecoration((Control)this.snippetsRepoPushBranchField.getTextControl((Composite)pushGroup), 16512);
        this.snippetsRepoPushBranchDecoration.setImage(this.errorDecoration.getImage());
        this.addField((FieldEditor)this.snippetsRepoPushBranchField);
        this.updateMargins(pushGroup);
    }

    private void updateMargins(Group group) {
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
    }

    public boolean performOk() {
        boolean dirty = this.isDirty();
        boolean ok = super.performOk();
        if (ok && dirty) {
            this.bus.post((Object)new EclipseGitSnippetRepository.SnippetRepositoryConfigurationChangedEvent());
        }
        return ok;
    }

    private boolean isDirty() {
        String oldRepoFetchUrl = this.getPreferenceStore().getString("snippets.repo.url");
        if (!this.snippetsRepoFetchUrlField.getStringValue().equals(oldRepoFetchUrl)) {
            return true;
        }
        String oldRepoPushUrl = this.getPreferenceStore().getString("snippets.repo.push.url");
        if (!this.snippetsRepoPushUrlField.getStringValue().equals(oldRepoPushUrl)) {
            return true;
        }
        String oldRepoPushBranch = this.getPreferenceStore().getString("snippets.repo.push.branch");
        return !this.snippetsRepoPushBranchField.getStringValue().equals(oldRepoPushBranch);
    }

    private final class StringFieldEditorWithPrefix
    extends StringFieldEditor {
        private Label prefixLabel;

        private StringFieldEditorWithPrefix(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.getTextControl().getLayoutData()).horizontalSpan = numColumns - 2;
        }

        public int getNumberOfControls() {
            return 3;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns - 1);
            this.prefixLabel = this.getPrefixControl(parent);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.widthHint = this.prefixLabel.computeSize((int)-1, (int)-1, (boolean)true).x;
            this.prefixLabel.setLayoutData((Object)gd);
        }

        private Label getPrefixControl(Composite parent) {
            if (this.prefixLabel == null) {
                this.prefixLabel = new Label(parent, 0);
                this.prefixLabel.setText("/format-4");
                this.prefixLabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        StringFieldEditorWithPrefix.this.prefixLabel = null;
                    }
                });
            }
            return this.prefixLabel;
        }

        protected boolean doCheckState() {
            String message = SnipmatchPreferencePage.this.branchValidator.isValid(this.getStringValue());
            SnipmatchPreferencePage.this.snippetsRepoPushBranchDecoration.setDescriptionText(message);
            if (message == null) {
                SnipmatchPreferencePage.this.snippetsRepoPushBranchDecoration.hide();
            } else {
                SnipmatchPreferencePage.this.snippetsRepoPushBranchDecoration.show();
            }
            return message == null;
        }
    }

    private final class UriInputValidator
    implements IInputValidator {
        private UriInputValidator() {
        }

        public String isValid(String newText) {
            if (newText.isEmpty()) {
                return Messages.PREFPAGE_ERROR_INVALID_REPO_URL;
            }
            try {
                new URI(newText);
                return null;
            }
            catch (URISyntaxException e) {
                return e.getMessage();
            }
        }
    }
}

