/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import javax.inject.Singleton;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.recommenders.internal.snipmatch.rcp.EclipseGitSnippetRepository;
import org.eclipse.recommenders.internal.snipmatch.rcp.SnipmatchRcpPreferences;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnipmatchRcpModule
extends AbstractModule {
    public static final String SNIPPET_REPOSITORY_BASEDIR = "SNIPPET_REPOSITORY_BASEDIR";
    private static final Logger LOG = LoggerFactory.getLogger(SnipmatchRcpModule.class);

    protected void configure() {
        Multibinder uriBinder = Multibinder.newSetBinder((Binder)this.binder(), ISnippetRepository.class);
        uriBinder.addBinding().to(EclipseGitSnippetRepository.class);
        this.bind(EclipseGitSnippetRepository.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public SnipmatchRcpPreferences provide(IWorkbench wb) {
        IEclipseContext context = (IEclipseContext)wb.getService(IEclipseContext.class);
        return (SnipmatchRcpPreferences)ContextInjectionFactory.make(SnipmatchRcpPreferences.class, (IEclipseContext)context);
    }

    @Provides
    @Singleton
    @Named(value="SNIPPET_REPOSITORY_BASEDIR")
    public File provideBasedir(IWorkspaceRoot root) {
        File recommendersRoot = new File(root.getLocation().toFile(), ".recommenders");
        File snipmatchRoot = new File(recommendersRoot, "snipmatch");
        File snippetRepositoryBasedir = new File(snipmatchRoot, "repositories");
        try {
            Files.createParentDirs((File)snippetRepositoryBasedir);
        }
        catch (IOException e) {
            LOG.error("Failed to bind file name {}.", (Object)snippetRepositoryBasedir, (Object)e);
        }
        return snippetRepositoryBasedir;
    }

    @Provides
    public IThemeManager provideThemeManager(IWorkbench wb) throws PartInitException {
        return wb.getThemeManager();
    }

    @Provides
    public ITheme provideThemeManager(IThemeManager mgr) throws PartInitException {
        return mgr.getCurrentTheme();
    }

    @Provides
    public ColorRegistry provideColorRegistry(ITheme theme) throws PartInitException {
        return theme.getColorRegistry();
    }

    @Provides
    public FontRegistry provideFontRegistry(ITheme theme) throws PartInitException {
        return theme.getFontRegistry();
    }
}

