/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.recommenders.internal.stacktraces.rcp.ErrorReportWizard;
import org.eclipse.recommenders.internal.stacktraces.rcp.LogMessages;
import org.eclipse.recommenders.internal.stacktraces.rcp.PreferenceInitializer;
import org.eclipse.recommenders.internal.stacktraces.rcp.UploadJob;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReport;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ErrorReports;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;

public class LogListener
implements ILogListener,
IStartup {
    private static final String STAND_IN_MESSAGE = "Stand-In Stacktrace supplied by Eclipse Stacktraces & Error Reporting Tool";
    private static Method SET_EXCEPTION = (Method)Reflections.getDeclaredMethod(Status.class, (String)"setException", (Class[])new Class[]{Throwable.class}).orNull();
    private Cache<String, ErrorReport> cache = CacheBuilder.newBuilder().maximumSize(30L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private IObservableList errorReports;
    private volatile boolean isDialogOpen;
    private Settings settings;

    public LogListener() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                LogListener.this.errorReports = Properties.selfList(ErrorReport.class).observe((Object)Lists.newArrayList());
            }
        });
    }

    public void logging(IStatus status, String nouse) {
        this.readSettings();
        if (this.ignoreAllLogEvents()) {
            return;
        }
        if (!this.isErrorSeverity(status) || !this.isEclipsePluginId(status)) {
            return;
        }
        LogListener.insertDebugStacktraceIfEmpty(status);
        ErrorReport report = ErrorReports.newErrorReport(status, this.settings);
        if (this.settings.isSkipSimilarErrors() && this.sentSimilarErrorBefore(report)) {
            return;
        }
        this.putIntoCache(report);
        this.checkAndSend(report);
    }

    private void readSettings() {
        this.settings = PreferenceInitializer.readSettings();
    }

    @VisibleForTesting
    public static void insertDebugStacktraceIfEmpty(IStatus status) {
        if (status.getException() == null && status instanceof Status && SET_EXCEPTION != null) {
            RuntimeException syntetic = new RuntimeException(STAND_IN_MESSAGE);
            syntetic.fillInStackTrace();
            try {
                SET_EXCEPTION.invoke((Object)status, syntetic);
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, (Throwable)e, (Object[])new Object[]{SET_EXCEPTION});
            }
        }
    }

    private boolean ignoreAllLogEvents() {
        return this.settings.getAction() == SendAction.IGNORE;
    }

    private boolean isErrorSeverity(IStatus status) {
        return status.matches(4);
    }

    private boolean sentSimilarErrorBefore(ErrorReport report) {
        return this.cache.getIfPresent((Object)this.computeCacheKey(report)) != null;
    }

    private String computeCacheKey(ErrorReport report) {
        return report.getStatus().getFingerprint();
    }

    private void putIntoCache(ErrorReport report) {
        this.cache.put((Object)this.computeCacheKey(report), (Object)report);
    }

    private boolean isEclipsePluginId(IStatus status) {
        String pluginId = status.getPlugin();
        return this.startsWithRecommendersOrCodetrails(pluginId);
    }

    private boolean startsWithRecommendersOrCodetrails(String s) {
        return StringUtils.startsWith((CharSequence)s, (CharSequence)"org.eclipse.") || StringUtils.startsWith((CharSequence)s, (CharSequence)"com.codetrails");
    }

    @VisibleForTesting
    protected void checkAndSend(final ErrorReport report) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LogListener.this.errorReports.add((Object)report);
                if (LogListener.this.isDialogOpen) {
                    return;
                }
                if (LogListener.this.settings.getAction() == SendAction.ASK) {
                    LogListener.this.isDialogOpen = true;
                    ErrorReportWizard stacktraceWizard = new ErrorReportWizard(LogListener.this.settings, LogListener.this.errorReports);
                    WizardDialog wizardDialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)stacktraceWizard);
                    int open = wizardDialog.open();
                    LogListener.this.isDialogOpen = false;
                    if (open != 0) {
                        LogListener.this.clear();
                        return;
                    }
                    if (LogListener.this.ignoreAllLogEvents()) {
                        return;
                    }
                    LogListener.this.sendList();
                    LogListener.this.clear();
                }
            }
        });
    }

    private void clear() {
        this.errorReports.clear();
    }

    private void sendList() {
        for (Object entry : this.errorReports) {
            ErrorReport report = (ErrorReport)Checks.cast(entry);
            this.sendStatus(report);
        }
    }

    private void sendStatus(ErrorReport report) {
        if (this.ignoreAllLogEvents()) {
            return;
        }
        new UploadJob(report, this.settings, URI.create(this.settings.getServerUrl())).schedule();
    }

    public void earlyStartup() {
        Platform.addLogListener((ILogListener)this);
    }
}

